#!/bin/bash
#
# Copyright (C) 2016 OmniROM Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
echo -e "Enter the AOSP ref to merge";
read ref;

echo -e "Do you want to merge it like squash ? type "yes" or "no" "
read squash

OPERATION="${squash}"

branch_name=${ref}"-merge"

branch_current="android-15"

cd ../../../

while read path;
    do

    project=`echo android_${path} | sed -e 's/\//\_/g'`;
    aosp_project=${path};
    if [ "${path}" == "build" ] ; then
        path="build/make";
    fi

    echo "";
    echo "=====================================================================";
    echo " PROJECT: ${project} -> [ ${path}/ ]";
    echo "";

    rm -fr $path;
    echo " -> repo sync ${path}";
    ret=$(repo sync -d --force-sync ${path} 2>&1);
    cd $path;

    if [[ "${OPERATION}" == "yes" ]]; then
        if git branch | grep ${branch_name} > /dev/null; then
            git branch -D ${branch_name} > /dev/null
        fi

        echo " -> creating branch ${branch_name}";
        ret=$(git checkout -b ${branch_name} 2>&1);
        ret=$(repo start ${branch_name});
    fi

    if [[ -n "$(git status --porcelain)" ]]; then
        # make sure that environment is clean
        ret=$(git merge --abort 2>&1);
    fi

    echo " -> Merging remote: https://android.googlesource.com/platform/$aosp_project ${ref}";
    ret=$(git pull https://android.googlesource.com/platform/$aosp_project ${ref} 2>&1);

    if [[ -n "$(git status --porcelain)" ]]; then
        echo -e " -> \e[33mWARNING!: \e[31mMERGE CONFLICT\e[0m";
        echo -e " -> please fix the merge conflict before push it.";
    else
        if [[ "${OPERATION}" == "yes" ]]; then
            echo " -> merging squashed commits into ${branch_current} branch";
            ret=$(git checkout ${branch_current} 2>&1);
            ret=$(git merge --squash ${branch_name} 2>&1);
            ret=$(git add . 2>&1);
            ret=$(git commit --no-edit 2>&1);
        fi
        echo -e " -> \e[32mDONE!\e[0m";
    fi

    cd - > /dev/null;

done < vendor/omni/utils/aosp-forked-list;
