//
// Copyright (C) 2015 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#ifndef UPDATE_ENGINE_PAYLOAD_GENERATOR_VERITY_UTILS_H_
#define UPDATE_ENGINE_PAYLOAD_GENERATOR_VERITY_UTILS_H_

#include <string>

namespace chromeos_update_engine {

bool GetVerityRootfsSize(const std::string& kernel_dev, uint64_t* rootfs_size);

bool ParseVerityRootfsSize(const std::string& kernel_cmdline,
                           uint64_t* rootfs_size);

}  // namespace chromeos_update_engine

#endif  // UPDATE_ENGINE_PAYLOAD_GENERATOR_VERITY_UTILS_H_
