/*
 * Copyright 2020, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.security.remoteprovisioning;

/**
 * This parcelable provides information about the state of the attestation key pool.
 * @hide
 */
parcelable AttestationPoolStatus {
    /**
     * The number of signed attestation certificate chains which will expire when the date provided
     * to keystore to check against is reached.
     */
    int expiring;
    /**
     * The number of signed attestation certificate chains which have not yet been assigned to an
     * app. This should be less than or equal to signed keys. The remainder of `signed` -
     * `unassigned` gives the number of signed keys that have been assigned to an app.
     */
    int unassigned;
    /**
     * The number of signed attestation keys. This should be less than or equal to `total`. The
     * remainder of `total` - `attested` gives the number of keypairs available to be sent off to
     * the server for signing.
     */
    int attested;
    /**
     * The total number of attestation keys.
     */
    int total;
}
