// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <libsnapshot/snapshot_stub.h>

#include <android-base/logging.h>

#include <libsnapshot/snapshot_stats.h>

using android::fs_mgr::CreateLogicalPartitionParams;
using chromeos_update_engine::DeltaArchiveManifest;
using chromeos_update_engine::FileDescriptor;

namespace android::snapshot {

std::unique_ptr<ISnapshotManager> SnapshotManagerStub::New() {
    return std::make_unique<SnapshotManagerStub>();
}

bool SnapshotManagerStub::BeginUpdate() {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::CancelUpdate() {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::FinishedSnapshotWrites(bool) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::InitiateMerge(uint64_t*) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

UpdateState SnapshotManagerStub::ProcessUpdateState(const std::function<bool()>&,
                                                    const std::function<bool()>&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return UpdateState::None;
}

UpdateState SnapshotManagerStub::GetUpdateState(double*) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return UpdateState::None;
}

Return SnapshotManagerStub::CreateUpdateSnapshots(const DeltaArchiveManifest&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return Return::Error();
}

bool SnapshotManagerStub::MapUpdateSnapshot(const CreateLogicalPartitionParams&, std::string*) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::UnmapUpdateSnapshot(const std::string&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::NeedSnapshotsInFirstStageMount() {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::CreateLogicalAndSnapshotPartitions(const std::string&,
                                                             const std::chrono::milliseconds&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::HandleImminentDataWipe(const std::function<void()>&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

bool SnapshotManagerStub::FinishMergeInRecovery() {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

CreateResult SnapshotManagerStub::RecoveryCreateSnapshotDevices() {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return CreateResult::ERROR;
}

CreateResult SnapshotManagerStub::RecoveryCreateSnapshotDevices(
        const std::unique_ptr<AutoDevice>&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return CreateResult::ERROR;
}

bool SnapshotManagerStub::Dump(std::ostream&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return false;
}

std::unique_ptr<AutoDevice> SnapshotManagerStub::EnsureMetadataMounted() {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return nullptr;
}

class SnapshotMergeStatsStub : public ISnapshotMergeStats {
    bool Start() override { return false; }
    void set_state(android::snapshot::UpdateState) override {}
    void set_cow_file_size(uint64_t) override {}
    uint64_t cow_file_size() override { return 0; }
    std::unique_ptr<Result> Finish() override { return nullptr; }
};

ISnapshotMergeStats* SnapshotManagerStub::GetSnapshotMergeStatsInstance() {
    static SnapshotMergeStatsStub snapshot_merge_stats;
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return &snapshot_merge_stats;
}

std::unique_ptr<ISnapshotWriter> SnapshotManagerStub::OpenSnapshotWriter(
        const CreateLogicalPartitionParams&, const std::optional<std::string>&) {
    LOG(ERROR) << __FUNCTION__ << " should never be called.";
    return nullptr;
}

}  // namespace android::snapshot
