/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <time.h>

#include <gtest/gtest.h>
// Test the APIs in this standalone include file
#include <log/log_time.h>

TEST(liblog, log_time) {
#ifdef __ANDROID__

#ifdef _SYSTEM_CORE_INCLUDE_PRIVATE_ANDROID_LOGGER_H_
    log_time(CLOCK_MONOTONIC);

    EXPECT_EQ(log_time, log_time::EPOCH);
#endif

    struct timespec ts;
    clock_gettime(CLOCK_MONOTONIC, &ts);
    log_time tl(ts);

    EXPECT_EQ(tl, ts);
    EXPECT_GE(tl, ts);
    EXPECT_LE(tl, ts);

#else
    GTEST_LOG_(INFO) << "This test does nothing.\n";
#endif
}
