/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.libraries.rcs.simpleclient.protocol.msrp;

import com.google.auto.value.AutoValue;

/**
 * Single header in MSRP chunk (From-Path, To-Path, ...)
 */
@AutoValue
public abstract class MsrpChunkHeader {

    public static Builder newBuilder() {
        return new AutoValue_MsrpChunkHeader.Builder();
    }

    public abstract String name();

    public abstract String value();

    /**
     * Builder for  new MSRP header.
     */
    @AutoValue.Builder
    public static abstract class Builder {

        public abstract Builder name(String name);

        public abstract Builder value(String value);

        public abstract MsrpChunkHeader build();
    }
}
