/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.phone.common.mail.utility;

import java.io.IOException;
import java.io.OutputStream;

/**
 * A simple pass-thru OutputStream that also counts how many bytes are written to it and
 * makes that count available to callers.
 */
public class CountingOutputStream extends OutputStream {
    private long mCount;
    private final OutputStream mOutputStream;

    public CountingOutputStream(OutputStream outputStream) {
        mOutputStream = outputStream;
    }

    public long getCount() {
        return mCount;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        mOutputStream.write(buffer, offset, count);
        mCount += count;
    }

    @Override
    public void write(int oneByte) throws IOException {
        mOutputStream.write(oneByte);
        mCount++;
    }
}