/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.cts.net.hostside;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Intent;
import android.os.Bundle;
import android.view.WindowManager;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MyActivity extends Activity {
    private final LinkedBlockingQueue<Integer> mResult = new LinkedBlockingQueue<>(1);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON
                | WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);

        // Dismiss the keyguard so that the tests can click on the VPN confirmation dialog.
        // FLAG_DISMISS_KEYGUARD is not sufficient to do this because as soon as the dialog appears,
        // this activity goes into the background and the keyguard reappears.
        getSystemService(KeyguardManager.class).requestDismissKeyguard(this, null /* callback */);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (mResult.offer(resultCode) == false) {
            throw new RuntimeException("Queue is full! This should never happen");
        }
    }

    public Integer getResult(int timeoutMs) throws InterruptedException {
        return mResult.poll(timeoutMs, TimeUnit.MILLISECONDS);
    }
}
