/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import dalvik.system.BaseDexClassLoader;

public class WrappedClassLoader
extends ClassLoader {
    private ClassLoader mPrimaryClassLoader;
    private ClassLoader mSecondaryClassLoader;

    public WrappedClassLoader(ClassLoader primary, ClassLoader secondary) {
        this.mPrimaryClassLoader = primary;
        this.mSecondaryClassLoader = secondary;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.mPrimaryClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.mSecondaryClassLoader.loadClass(name);
        }
    }

    @Override
    public String findLibrary(String name) {
        String path = null;
        if (this.mPrimaryClassLoader instanceof BaseDexClassLoader && (path = ((BaseDexClassLoader)this.mPrimaryClassLoader).findLibrary(name)) != null) {
            return path;
        }
        if (this.mSecondaryClassLoader instanceof BaseDexClassLoader) {
            path = ((BaseDexClassLoader)this.mSecondaryClassLoader).findLibrary(name);
        }
        return path;
    }
}

