/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.chromium.net.UrlResponseInfo;

public final class UrlResponseInfoImpl
extends UrlResponseInfo {
    private final List<String> mResponseInfoUrlChain;
    private final int mHttpStatusCode;
    private final String mHttpStatusText;
    private final boolean mWasCached;
    private final String mNegotiatedProtocol;
    private final String mProxyServer;
    private final AtomicLong mReceivedByteCount;
    private final HeaderBlockImpl mHeaders;

    public UrlResponseInfoImpl(List<String> urlChain, int httpStatusCode, String httpStatusText, List<Map.Entry<String, String>> allHeadersList, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        this.mResponseInfoUrlChain = Collections.unmodifiableList(urlChain);
        this.mHttpStatusCode = httpStatusCode;
        this.mHttpStatusText = httpStatusText;
        this.mHeaders = new HeaderBlockImpl(Collections.unmodifiableList(allHeadersList));
        this.mWasCached = wasCached;
        this.mNegotiatedProtocol = negotiatedProtocol;
        this.mProxyServer = proxyServer;
        this.mReceivedByteCount = new AtomicLong(receivedByteCount);
    }

    @Deprecated
    public UrlResponseInfoImpl(List<String> urlChain, int httpStatusCode, String httpStatusText, List<Map.Entry<String, String>> allHeadersList, boolean wasCached, String negotiatedProtocol, String proxyServer) {
        this(urlChain, httpStatusCode, httpStatusText, allHeadersList, wasCached, negotiatedProtocol, proxyServer, 0L);
    }

    public String getUrl() {
        return this.mResponseInfoUrlChain.get(this.mResponseInfoUrlChain.size() - 1);
    }

    public List<String> getUrlChain() {
        return this.mResponseInfoUrlChain;
    }

    public int getHttpStatusCode() {
        return this.mHttpStatusCode;
    }

    public String getHttpStatusText() {
        return this.mHttpStatusText;
    }

    public List<Map.Entry<String, String>> getAllHeadersAsList() {
        return this.mHeaders.getAsList();
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.mHeaders.getAsMap();
    }

    public boolean wasCached() {
        return this.mWasCached;
    }

    public String getNegotiatedProtocol() {
        return this.mNegotiatedProtocol;
    }

    public String getProxyServer() {
        return this.mProxyServer;
    }

    public long getReceivedByteCount() {
        return this.mReceivedByteCount.get();
    }

    public String toString() {
        return String.format(Locale.ROOT, "UrlResponseInfo@[%s][%s]: urlChain = %s, httpStatus = %d %s, headers = %s, wasCached = %b, negotiatedProtocol = %s, proxyServer= %s, receivedByteCount = %d", Integer.toHexString(System.identityHashCode((Object)this)), this.getUrl(), this.getUrlChain().toString(), this.getHttpStatusCode(), this.getHttpStatusText(), this.getAllHeadersAsList().toString(), this.wasCached(), this.getNegotiatedProtocol(), this.getProxyServer(), this.getReceivedByteCount());
    }

    public void setReceivedByteCount(long currentReceivedByteCount) {
        this.mReceivedByteCount.set(currentReceivedByteCount);
    }

    public static final class HeaderBlockImpl
    extends UrlResponseInfo.HeaderBlock {
        private final List<Map.Entry<String, String>> mAllHeadersList;
        private Map<String, List<String>> mHeadersMap;

        HeaderBlockImpl(List<Map.Entry<String, String>> allHeadersList) {
            this.mAllHeadersList = allHeadersList;
        }

        public List<Map.Entry<String, String>> getAsList() {
            return this.mAllHeadersList;
        }

        public Map<String, List<String>> getAsMap() {
            if (this.mHeadersMap != null) {
                return this.mHeadersMap;
            }
            TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, String> entry : this.mAllHeadersList) {
                ArrayList<String> values = new ArrayList<String>();
                if (map.containsKey(entry.getKey())) {
                    values.addAll((Collection)map.get(entry.getKey()));
                }
                values.add(entry.getValue());
                map.put(entry.getKey(), Collections.unmodifiableList(values));
            }
            this.mHeadersMap = Collections.unmodifiableMap(map);
            return this.mHeadersMap;
        }
    }
}

