/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.annotation.SuppressLint;
import android.os.Build;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.impl.CronetEngineBase;

public class BidirectionalStreamBuilderImpl
extends ExperimentalBidirectionalStream.Builder {
    private final CronetEngineBase mCronetEngine;
    private final String mUrl;
    private final BidirectionalStream.Callback mCallback;
    private final Executor mExecutor;
    private final ArrayList<Map.Entry<String, String>> mRequestHeaders = new ArrayList();
    private String mHttpMethod = "POST";
    private int mPriority = 3;
    private boolean mDelayRequestHeadersUntilFirstFlush;
    private Collection<Object> mRequestAnnotations;
    private boolean mTrafficStatsTagSet;
    private int mTrafficStatsTag;
    private boolean mTrafficStatsUidSet;
    private int mTrafficStatsUid;
    private long mNetworkHandle = -1L;

    BidirectionalStreamBuilderImpl(String url, BidirectionalStream.Callback callback, Executor executor, CronetEngineBase cronetEngine) {
        if (url == null) {
            throw new NullPointerException("URL is required.");
        }
        if (callback == null) {
            throw new NullPointerException("Callback is required.");
        }
        if (executor == null) {
            throw new NullPointerException("Executor is required.");
        }
        if (cronetEngine == null) {
            throw new NullPointerException("CronetEngine is required.");
        }
        this.mUrl = url;
        this.mCallback = callback;
        this.mExecutor = executor;
        this.mCronetEngine = cronetEngine;
    }

    public BidirectionalStreamBuilderImpl setHttpMethod(String method) {
        if (method == null) {
            throw new NullPointerException("Method is required.");
        }
        this.mHttpMethod = method;
        return this;
    }

    public BidirectionalStreamBuilderImpl addHeader(String header, String value) {
        if (header == null) {
            throw new NullPointerException("Invalid header name.");
        }
        if (value == null) {
            throw new NullPointerException("Invalid header value.");
        }
        this.mRequestHeaders.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
        return this;
    }

    public BidirectionalStreamBuilderImpl setPriority(int priority) {
        this.mPriority = priority;
        return this;
    }

    public BidirectionalStreamBuilderImpl delayRequestHeadersUntilFirstFlush(boolean delayRequestHeadersUntilFirstFlush) {
        this.mDelayRequestHeadersUntilFirstFlush = delayRequestHeadersUntilFirstFlush;
        return this;
    }

    public ExperimentalBidirectionalStream.Builder addRequestAnnotation(Object annotation) {
        if (annotation == null) {
            throw new NullPointerException("Invalid metrics annotation.");
        }
        if (this.mRequestAnnotations == null) {
            this.mRequestAnnotations = new ArrayList<Object>();
        }
        this.mRequestAnnotations.add(annotation);
        return this;
    }

    public ExperimentalBidirectionalStream.Builder setTrafficStatsTag(int tag) {
        this.mTrafficStatsTagSet = true;
        this.mTrafficStatsTag = tag;
        return this;
    }

    public ExperimentalBidirectionalStream.Builder setTrafficStatsUid(int uid) {
        this.mTrafficStatsUidSet = true;
        this.mTrafficStatsUid = uid;
        return this;
    }

    public ExperimentalBidirectionalStream.Builder bindToNetwork(long networkHandle) {
        if (Build.VERSION.SDK_INT < 23) {
            throw new UnsupportedOperationException("The multi-network API is available starting from Android Marshmallow");
        }
        this.mNetworkHandle = networkHandle;
        return this;
    }

    @SuppressLint(value={"WrongConstant"})
    public ExperimentalBidirectionalStream build() {
        return this.mCronetEngine.createBidirectionalStream(this.mUrl, this.mCallback, this.mExecutor, this.mHttpMethod, this.mRequestHeaders, this.mPriority, this.mDelayRequestHeadersUntilFirstFlush, this.mRequestAnnotations, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mNetworkHandle);
    }
}

