/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.net.AndroidCertVerifyResult;
import org.chromium.net.X509UtilJni;

@JNINamespace(value="net")
@MainDex
public class X509Util {
    private static final String TAG = "X509Util";
    private static CertificateFactory sCertificateFactory;
    private static final String OID_TLS_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String OID_ANY_EKU = "2.5.29.37.0";
    private static final String OID_SERVER_GATED_NETSCAPE = "2.16.840.1.113730.4.1";
    private static final String OID_SERVER_GATED_MICROSOFT = "1.3.6.1.4.1.311.10.3.3";
    private static X509TrustManagerExtensions sDefaultTrustManager;
    private static TrustStorageListener sTrustStorageListener;
    private static X509TrustManagerExtensions sTestTrustManager;
    private static KeyStore sTestKeyStore;
    private static KeyStore sSystemKeyStore;
    private static File sSystemCertificateDirectory;
    private static Set<Pair<X500Principal, PublicKey>> sSystemTrustAnchorCache;
    private static boolean sLoadedSystemKeyStore;
    private static final Object sLock;
    private static final char[] HEX_DIGITS;

    private static List<X509Certificate> checkServerTrustedIgnoringRuntimeException(X509TrustManagerExtensions tm, X509Certificate[] chain, String authType, String host) throws CertificateException {
        try {
            return tm.checkServerTrusted(chain, authType, host);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "checkServerTrusted() unexpectedly threw: %s", e);
            throw new CertificateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Object object = sLock;
        synchronized (object) {
            X509Util.ensureInitializedLocked();
        }
    }

    private static void ensureInitializedLocked() throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        assert (Thread.holdsLock(sLock));
        if (sCertificateFactory == null) {
            sCertificateFactory = CertificateFactory.getInstance("X.509");
        }
        if (sDefaultTrustManager == null) {
            sDefaultTrustManager = X509Util.createTrustManager(null);
        }
        if (!sLoadedSystemKeyStore) {
            try {
                sSystemKeyStore = KeyStore.getInstance("AndroidCAStore");
                try {
                    sSystemKeyStore.load(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sSystemCertificateDirectory = new File(System.getenv("ANDROID_ROOT") + "/etc/security/cacerts");
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            sLoadedSystemKeyStore = true;
        }
        if (sSystemTrustAnchorCache == null) {
            sSystemTrustAnchorCache = new HashSet<Pair<X500Principal, PublicKey>>();
        }
        if (sTestKeyStore == null) {
            sTestKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                sTestKeyStore.load(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (sTestTrustManager == null) {
            sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
        }
        if (sTrustStorageListener == null) {
            sTrustStorageListener = new TrustStorageListener();
            IntentFilter filter = new IntentFilter();
            if (Build.VERSION.SDK_INT >= 26) {
                filter.addAction("android.security.action.KEYCHAIN_CHANGED");
                filter.addAction("android.security.action.KEY_ACCESS_CHANGED");
                filter.addAction("android.security.action.TRUST_STORE_CHANGED");
            } else {
                String action = "android.security.STORAGE_CHANGED";
                filter.addAction(action);
            }
            ContextUtils.registerNonExportedBroadcastReceiver(ContextUtils.getApplicationContext(), sTrustStorageListener, filter);
        }
    }

    private static X509TrustManagerExtensions createTrustManager(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        TrustManager[] trustManagers = null;
        try {
            trustManagers = tmf.getTrustManagers();
        }
        catch (RuntimeException e) {
            Log.e(TAG, "TrustManagerFactory.getTrustManagers() unexpectedly threw: %s", e);
            throw new KeyStoreException(e);
        }
        for (TrustManager tm : trustManagers) {
            if (!(tm instanceof X509TrustManager)) continue;
            try {
                return new X509TrustManagerExtensions((X509TrustManager)tm);
            }
            catch (IllegalArgumentException e) {
                String className = tm.getClass().getName();
                Log.e(TAG, "Error creating trust manager (" + className + "): " + e, new Object[0]);
            }
        }
        Log.e(TAG, "Could not find suitable trust manager", new Object[0]);
        return null;
    }

    private static void reloadTestTrustManager() throws KeyStoreException, NoSuchAlgorithmException {
        assert (Thread.holdsLock(sLock));
        sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadDefaultTrustManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object = sLock;
        synchronized (object) {
            sDefaultTrustManager = null;
            sSystemTrustAnchorCache = null;
            X509Util.ensureInitializedLocked();
        }
        X509UtilJni.get().notifyKeyChainChanged();
    }

    public static X509Certificate createCertificateFromBytes(byte[] derBytes) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.ensureInitialized();
        return (X509Certificate)sCertificateFactory.generateCertificate(new ByteArrayInputStream(derBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTestRootCertificate(byte[] rootCertBytes) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.ensureInitialized();
        X509Certificate rootCert = X509Util.createCertificateFromBytes(rootCertBytes);
        Object object = sLock;
        synchronized (object) {
            sTestKeyStore.setCertificateEntry("root_cert_" + Integer.toString(sTestKeyStore.size()), rootCert);
            X509Util.reloadTestTrustManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.ensureInitialized();
        Object object = sLock;
        synchronized (object) {
            try {
                sTestKeyStore.load(null);
                X509Util.reloadTestTrustManager();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String hashPrincipal(X500Principal principal) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance("MD5").digest(principal.getEncoded());
        char[] hexChars = new char[8];
        for (int i = 0; i < 4; ++i) {
            hexChars[2 * i] = HEX_DIGITS[digest[3 - i] >> 4 & 0xF];
            hexChars[2 * i + 1] = HEX_DIGITS[digest[3 - i] & 0xF];
        }
        return new String(hexChars);
    }

    private static boolean isKnownRoot(X509Certificate root) throws NoSuchAlgorithmException, KeyStoreException {
        String alias;
        assert (Thread.holdsLock(sLock));
        if (sSystemKeyStore == null) {
            return false;
        }
        Pair key = new Pair((Object)root.getSubjectX500Principal(), (Object)root.getPublicKey());
        if (sSystemTrustAnchorCache.contains(key)) {
            return true;
        }
        String hash = X509Util.hashPrincipal(root.getSubjectX500Principal());
        int i = 0;
        while (new File(sSystemCertificateDirectory, alias = hash + "." + i).exists()) {
            Certificate anchor = sSystemKeyStore.getCertificate("system:" + alias);
            if (anchor != null) {
                if (!(anchor instanceof X509Certificate)) {
                    String className = anchor.getClass().getName();
                    Log.e(TAG, "Anchor " + alias + " not an X509Certificate: " + className, new Object[0]);
                } else {
                    X509Certificate anchorX509 = (X509Certificate)anchor;
                    if (root.getSubjectX500Principal().equals(anchorX509.getSubjectX500Principal()) && root.getPublicKey().equals(anchorX509.getPublicKey())) {
                        sSystemTrustAnchorCache.add((Pair<X500Principal, PublicKey>)key);
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    static boolean verifyKeyUsage(X509Certificate certificate) throws CertificateException {
        List<String> ekuOids;
        try {
            ekuOids = certificate.getExtendedKeyUsage();
        }
        catch (NullPointerException e) {
            return false;
        }
        if (ekuOids == null) {
            return true;
        }
        for (String ekuOid : ekuOids) {
            if (!ekuOid.equals(OID_TLS_SERVER_AUTH) && !ekuOid.equals(OID_ANY_EKU) && !ekuOid.equals(OID_SERVER_GATED_NETSCAPE) && !ekuOid.equals(OID_SERVER_GATED_MICROSOFT)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) throws KeyStoreException, NoSuchAlgorithmException {
        if (certChain == null || certChain.length == 0 || certChain[0] == null) {
            throw new IllegalArgumentException("Expected non-null and non-empty certificate chain passed as |certChain|. |certChain|=" + Arrays.deepToString((Object[])certChain));
        }
        try {
            X509Util.ensureInitialized();
        }
        catch (CertificateException e) {
            return new AndroidCertVerifyResult(-1);
        }
        ArrayList<X509Certificate> serverCertificatesList = new ArrayList<X509Certificate>();
        try {
            serverCertificatesList.add(X509Util.createCertificateFromBytes(certChain[0]));
        }
        catch (CertificateException e) {
            return new AndroidCertVerifyResult(-5);
        }
        for (int i = 1; i < certChain.length; ++i) {
            try {
                serverCertificatesList.add(X509Util.createCertificateFromBytes(certChain[i]));
                continue;
            }
            catch (CertificateException e) {
                Log.w(TAG, "intermediate " + i + " failed parsing", new Object[0]);
            }
        }
        X509Certificate[] serverCertificates = serverCertificatesList.toArray(new X509Certificate[serverCertificatesList.size()]);
        try {
            serverCertificates[0].checkValidity();
            if (!X509Util.verifyKeyUsage(serverCertificates[0])) {
                return new AndroidCertVerifyResult(-6);
            }
        }
        catch (CertificateExpiredException e) {
            return new AndroidCertVerifyResult(-3);
        }
        catch (CertificateNotYetValidException e) {
            return new AndroidCertVerifyResult(-4);
        }
        catch (CertificateException e) {
            return new AndroidCertVerifyResult(-1);
        }
        Object object = sLock;
        synchronized (object) {
            List<X509Certificate> verifiedChain;
            if (sDefaultTrustManager == null) {
                return new AndroidCertVerifyResult(-1);
            }
            try {
                verifiedChain = X509Util.checkServerTrustedIgnoringRuntimeException(sDefaultTrustManager, serverCertificates, authType, host);
            }
            catch (CertificateException eDefaultManager) {
                try {
                    verifiedChain = X509Util.checkServerTrustedIgnoringRuntimeException(sTestTrustManager, serverCertificates, authType, host);
                }
                catch (CertificateException eTestManager) {
                    Log.i(TAG, "Failed to validate the certificate chain, error: " + eDefaultManager.getMessage(), new Object[0]);
                    return new AndroidCertVerifyResult(-2);
                }
            }
            boolean isIssuedByKnownRoot = false;
            if (verifiedChain.size() > 0) {
                X509Certificate root = verifiedChain.get(verifiedChain.size() - 1);
                isIssuedByKnownRoot = X509Util.isKnownRoot(root);
            }
            return new AndroidCertVerifyResult(0, isIssuedByKnownRoot, verifiedChain);
        }
    }

    static {
        sLock = new Object();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    static interface Natives {
        public void notifyKeyChainChanged();
    }

    private static final class TrustStorageListener
    extends BroadcastReceiver {
        private TrustStorageListener() {
        }

        public void onReceive(Context context, Intent intent) {
            boolean shouldReloadTrustManager = false;
            if (Build.VERSION.SDK_INT >= 26) {
                if ("android.security.action.KEYCHAIN_CHANGED".equals(intent.getAction()) || "android.security.action.TRUST_STORE_CHANGED".equals(intent.getAction())) {
                    shouldReloadTrustManager = true;
                } else if ("android.security.action.KEY_ACCESS_CHANGED".equals(intent.getAction()) && !intent.getBooleanExtra("android.security.extra.KEY_ACCESSIBLE", false)) {
                    shouldReloadTrustManager = true;
                }
            } else {
                String action = "android.security.STORAGE_CHANGED";
                shouldReloadTrustManager = action.equals(intent.getAction());
            }
            if (shouldReloadTrustManager) {
                try {
                    X509Util.reloadDefaultTrustManager();
                }
                catch (CertificateException e) {
                    Log.e(X509Util.TAG, "Unable to reload the default TrustManager", e);
                }
                catch (KeyStoreException e) {
                    Log.e(X509Util.TAG, "Unable to reload the default TrustManager", e);
                }
                catch (NoSuchAlgorithmException e) {
                    Log.e(X509Util.TAG, "Unable to reload the default TrustManager", e);
                }
            }
        }
    }
}

