/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.util.Pair;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.TraceEvent;
import org.chromium.base.task.PostTask;
import org.chromium.base.task.TaskTraits;

public class ChainedTasks {
    private final LinkedList<Pair<TaskTraits, Runnable>> mTasks = new LinkedList();
    @GuardedBy(value="mTasks")
    private boolean mFinalized;
    private volatile boolean mCanceled;
    private final Runnable mRunAndPost = new Runnable(){

        @Override
        public void run() {
            if (ChainedTasks.this.mCanceled) {
                return;
            }
            Pair<TaskTraits, Runnable> pair = ChainedTasks.this.mTasks.pop();
            try (TraceEvent e = TraceEvent.scoped("ChainedTask.run: " + ((Runnable)pair.second).getClass().getName());){
                ((Runnable)pair.second).run();
            }
            if (!ChainedTasks.this.mTasks.isEmpty()) {
                PostTask.postTask((TaskTraits)ChainedTasks.this.mTasks.peek().first, this);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TaskTraits traits, Runnable task) {
        LinkedList<Pair<TaskTraits, Runnable>> linkedList = this.mTasks;
        synchronized (linkedList) {
            assert (!this.mFinalized) : "Must not call add() after start()";
            this.mTasks.add((Pair<TaskTraits, Runnable>)new Pair((Object)traits, (Object)task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LinkedList<Pair<TaskTraits, Runnable>> linkedList = this.mTasks;
        synchronized (linkedList) {
            this.mFinalized = true;
            this.mCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean coalesceTasks) {
        LinkedList<Pair<TaskTraits, Runnable>> linkedList = this.mTasks;
        synchronized (linkedList) {
            assert (!this.mFinalized) : "Cannot call start() several times";
            this.mFinalized = true;
        }
        if (this.mTasks.isEmpty()) {
            return;
        }
        if (coalesceTasks) {
            TaskTraits traits = (TaskTraits)this.mTasks.peek().first;
            PostTask.runOrPostTask(traits, () -> {
                for (Pair pair : this.mTasks) {
                    assert (PostTask.canRunTaskImmediately((TaskTraits)pair.first));
                    ((Runnable)pair.second).run();
                    if (!this.mCanceled) continue;
                    return;
                }
            });
        } else {
            PostTask.postTask((TaskTraits)this.mTasks.peek().first, this.mRunAndPost);
        }
    }
}

