/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.chromium.base.TimeUtils;
import org.chromium.base.metrics.RecordHistogram;

public class TimingMetric
implements AutoCloseable {
    private final String mMetricName;
    private final int mTimerType;
    private long mStartTime;

    public static TimingMetric shortUptime(@NonNull String metricName) {
        TimingMetric ret = new TimingMetric(metricName, 0);
        ret.mStartTime = TimeUtils.uptimeMillis();
        return ret;
    }

    public static TimingMetric mediumUptime(@NonNull String metricName) {
        TimingMetric ret = new TimingMetric(metricName, 1);
        ret.mStartTime = TimeUtils.uptimeMillis();
        return ret;
    }

    public static TimingMetric shortThreadTime(@NonNull String metricName) {
        TimingMetric ret = new TimingMetric(metricName, 2);
        ret.mStartTime = TimeUtils.currentThreadTimeMillis();
        return ret;
    }

    private TimingMetric(String metricName, int timerType) {
        this.mMetricName = metricName;
        this.mTimerType = timerType;
    }

    @Override
    public void close() {
        String metricName = this.mMetricName;
        long startTime = this.mStartTime;
        if (startTime == 0L) {
            return;
        }
        this.mStartTime = 0L;
        switch (this.mTimerType) {
            case 0: {
                RecordHistogram.recordTimesHistogram(metricName, TimeUtils.uptimeMillis() - startTime);
                break;
            }
            case 1: {
                RecordHistogram.recordMediumTimesHistogram(metricName, TimeUtils.uptimeMillis() - startTime);
                break;
            }
            case 2: {
                RecordHistogram.recordTimesHistogram(metricName, TimeUtils.currentThreadTimeMillis() - startTime);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface TimerType {
        public static final int SHORT_UPTIME = 0;
        public static final int MEDIUM_UPTIME = 1;
        public static final int SHORT_THREAD_TIME = 2;
    }
}

