/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.content.res.Resources;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Printer;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AnyThread;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.EarlyTraceEvent;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TimeUtils;
import org.chromium.base.TraceEventJni;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.task.PostTask;
import org.chromium.base.task.TaskTraits;

@JNINamespace(value="base::android")
@MainDex
public class TraceEvent
implements AutoCloseable {
    private static volatile boolean sEnabled;
    private static AtomicBoolean sNativeTracingReady;
    private static AtomicBoolean sUiThreadReady;
    private static boolean sEventNameFilteringEnabled;
    public static final long ATRACE_TAG_WEBVIEW = 16L;
    public static final long ATRACE_TAG_APP = 4096L;
    private static ATrace sATrace;
    private final String mName;

    private TraceEvent(String name, String arg) {
        this.mName = name;
        TraceEvent.begin(name, arg);
    }

    @Override
    public void close() {
        TraceEvent.end(this.mName);
    }

    public static TraceEvent scoped(String name, String arg) {
        if (!EarlyTraceEvent.enabled() && !TraceEvent.enabled()) {
            return null;
        }
        return new TraceEvent(name, arg);
    }

    public static TraceEvent scoped(String name) {
        return TraceEvent.scoped(name, null);
    }

    @CalledByNative
    public static void setEnabled(boolean enabled) {
        if (enabled) {
            EarlyTraceEvent.disable();
        }
        if (sEnabled != enabled) {
            sEnabled = enabled;
            if (sATrace == null || !sATrace.hasActiveSession()) {
                ThreadUtils.getUiThreadLooper().setMessageLogging((Printer)(enabled ? LooperMonitorHolder.sInstance : null));
            }
        }
        if (sUiThreadReady.get()) {
            ViewHierarchyDumper.updateEnabledState();
        }
    }

    @CalledByNative
    public static void setEventNameFilteringEnabled(boolean enabled) {
        sEventNameFilteringEnabled = enabled;
    }

    public static boolean eventNameFilteringEnabled() {
        return sEventNameFilteringEnabled;
    }

    public static void maybeEnableEarlyTracing(long traceTag, boolean readCommandLine) {
        if (readCommandLine) {
            EarlyTraceEvent.maybeEnableInBrowserProcess();
        }
        if (traceTag != 0L) {
            sATrace = new ATrace(traceTag);
            if (sNativeTracingReady.get()) {
                sATrace.onNativeTracingReady();
            }
            if (sUiThreadReady.get()) {
                sATrace.onUiThreadReady();
            }
        }
        if (EarlyTraceEvent.enabled() && (sATrace == null || !sATrace.hasActiveSession())) {
            ThreadUtils.getUiThreadLooper().setMessageLogging((Printer)LooperMonitorHolder.sInstance);
        }
    }

    public static void onNativeTracingReady() {
        sNativeTracingReady.set(true);
        TraceEventJni.get().registerEnabledObserver();
        if (sATrace != null) {
            sATrace.onNativeTracingReady();
        }
    }

    static void onUiThreadReady() {
        sUiThreadReady.set(true);
        if (sATrace != null) {
            sATrace.onUiThreadReady();
        }
        if (sEnabled) {
            ViewHierarchyDumper.updateEnabledState();
        }
    }

    public static boolean enabled() {
        return sEnabled;
    }

    public static void instant(String name) {
        if (sEnabled) {
            TraceEventJni.get().instant(name, null);
        }
    }

    public static void instant(String name, String arg) {
        if (sEnabled) {
            TraceEventJni.get().instant(name, arg);
        }
    }

    public static void instantAndroidIPC(String name, long durMs) {
        if (sEnabled) {
            TraceEventJni.get().instantAndroidIPC(name, durMs);
        }
    }

    public static void snapshotViewHierarchy() {
        if (sEnabled && TraceEventJni.get().viewHierarchyDumpEnabled()) {
            TraceEvent.begin("instantAndroidViewHierarchy");
            ArrayList<ActivityInfo> views = TraceEvent.snapshotViewHierarchyState();
            if (views.isEmpty()) {
                TraceEvent.end("instantAndroidViewHierarchy");
                return;
            }
            long flow = views.hashCode();
            PostTask.postTask(TaskTraits.BEST_EFFORT, () -> TraceEventJni.get().initViewHierarchyDump(flow, views));
            TraceEvent.end("instantAndroidViewHierarchy", null, flow);
        }
    }

    public static void startAsync(String name, long id2) {
        EarlyTraceEvent.startAsync(name, id2);
        if (sEnabled) {
            TraceEventJni.get().startAsync(name, id2);
        } else if (sATrace != null) {
            sATrace.asyncTraceBegin(name, (int)id2);
        }
    }

    public static void finishAsync(String name, long id2) {
        EarlyTraceEvent.finishAsync(name, id2);
        if (sEnabled) {
            TraceEventJni.get().finishAsync(name, id2);
        } else if (sATrace != null) {
            sATrace.asyncTraceEnd(name, (int)id2);
        }
    }

    public static void begin(String name) {
        TraceEvent.begin(name, null);
    }

    public static void begin(String name, String arg) {
        EarlyTraceEvent.begin(name, false);
        if (sEnabled) {
            TraceEventJni.get().begin(name, arg);
        } else if (sATrace != null) {
            sATrace.traceBegin(name);
        }
    }

    public static void end(String name) {
        TraceEvent.end(name, null);
    }

    public static void end(String name, String arg) {
        TraceEvent.end(name, arg, 0L);
    }

    public static void end(String name, String arg, long flow) {
        EarlyTraceEvent.end(name, false);
        if (sEnabled) {
            TraceEventJni.get().end(name, arg, flow);
        } else if (sATrace != null) {
            sATrace.traceEnd();
        }
    }

    public static ArrayList<ActivityInfo> snapshotViewHierarchyState() {
        if (!ApplicationStatus.isInitialized()) {
            return new ArrayList<ActivityInfo>();
        }
        ArrayList<ActivityInfo> views = new ArrayList<ActivityInfo>(2);
        for (Activity a : ApplicationStatus.getRunningActivities()) {
            views.add(new ActivityInfo(a.getClass().getName()));
            ViewHierarchyDumper.dumpView(views.get(views.size() - 1), 0, a.getWindow().getDecorView().getRootView());
        }
        return views;
    }

    @CalledByNative
    public static void dumpViewHierarchy(long dumpProtoPtr, Object list) {
        if (!ApplicationStatus.isInitialized()) {
            return;
        }
        ArrayList activities = (ArrayList)list;
        for (ActivityInfo activity : activities) {
            long activityProtoPtr = TraceEventJni.get().startActivityDump(activity.mActivityName, dumpProtoPtr);
            for (ViewInfo view : activity.mViews) {
                String resource;
                try {
                    resource = view.mRes != null ? (view.mId == 0 || view.mId == -1 ? "__no_id__" : view.mRes.getResourceName(view.mId)) : "__no_resources__";
                }
                catch (Resources.NotFoundException e) {
                    resource = "__name_not_found__";
                }
                TraceEventJni.get().addViewDump(view.mId, view.mParentId, view.mIsShown, view.mIsDirty, view.mClassName, resource, activityProtoPtr);
            }
        }
    }

    static {
        sNativeTracingReady = new AtomicBoolean();
        sUiThreadReady = new AtomicBoolean();
    }

    private static final class ViewHierarchyDumper
    implements MessageQueue.IdleHandler {
        private static final String EVENT_NAME = "TraceEvent.ViewHierarchyDumper";
        private static final long MIN_VIEW_DUMP_INTERVAL_MILLIS = 1000L;
        private static boolean sEnabled;
        private static ViewHierarchyDumper sInstance;
        private long mLastDumpTs;

        private ViewHierarchyDumper() {
        }

        public final boolean queueIdle() {
            long now = TimeUtils.elapsedRealtimeMillis();
            if (this.mLastDumpTs == 0L || now - this.mLastDumpTs > 1000L) {
                this.mLastDumpTs = now;
                TraceEvent.snapshotViewHierarchy();
            }
            return true;
        }

        public static void updateEnabledState() {
            if (!ThreadUtils.runningOnUiThread()) {
                ThreadUtils.postOnUiThread(() -> ViewHierarchyDumper.updateEnabledState());
                return;
            }
            if (TraceEventJni.get().viewHierarchyDumpEnabled()) {
                if (sInstance == null) {
                    sInstance = new ViewHierarchyDumper();
                }
                ViewHierarchyDumper.enable();
            } else if (sInstance != null) {
                ViewHierarchyDumper.disable();
            }
        }

        private static void dumpView(ActivityInfo collection, int parentId, View v) {
            ThreadUtils.assertOnUiThread();
            int id2 = v.getId();
            collection.mViews.add(new ViewInfo(id2, parentId, v.isShown(), v.isDirty(), v.getClass().getSimpleName(), v.getResources()));
            if (v instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)v;
                for (int i = 0; i < vg.getChildCount(); ++i) {
                    ViewHierarchyDumper.dumpView(collection, id2, vg.getChildAt(i));
                }
            }
        }

        private static void enable() {
            ThreadUtils.assertOnUiThread();
            if (!sEnabled) {
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)sInstance);
                sEnabled = true;
            }
        }

        private static void disable() {
            ThreadUtils.assertOnUiThread();
            if (sEnabled) {
                Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)sInstance);
                sEnabled = false;
            }
        }
    }

    public static class ActivityInfo {
        public String mActivityName;
        public ArrayList<ViewInfo> mViews;

        public ActivityInfo(String activityName) {
            this.mActivityName = activityName;
            this.mViews = new ArrayList(125);
        }
    }

    public static class ViewInfo {
        private int mId;
        private int mParentId;
        private boolean mIsShown;
        private boolean mIsDirty;
        private String mClassName;
        private Resources mRes;

        public ViewInfo(int id2, int parentId, boolean isShown, boolean isDirty, String className, Resources res) {
            this.mId = id2;
            this.mParentId = parentId;
            this.mIsShown = isShown;
            this.mIsDirty = isDirty;
            this.mClassName = className;
            this.mRes = res;
        }
    }

    static interface Natives {
        public void registerEnabledObserver();

        public void startATrace(String var1);

        public void stopATrace();

        public void setupATraceStartupTrace(String var1);

        public void instant(String var1, String var2);

        public void begin(String var1, String var2);

        public void end(String var1, String var2, long var3);

        public void beginToplevel(String var1);

        public void endToplevel(String var1);

        public void startAsync(String var1, long var2);

        public void finishAsync(String var1, long var2);

        public boolean viewHierarchyDumpEnabled();

        public void initViewHierarchyDump(long var1, Object var3);

        public long startActivityDump(String var1, long var2);

        public void addViewDump(int var1, int var2, boolean var3, boolean var4, String var5, String var6, long var7);

        public void instantAndroidIPC(String var1, long var2);
    }

    private static final class LooperMonitorHolder {
        private static final BasicLooperMonitor sInstance = CommandLine.getInstance().hasSwitch("enable-idle-tracing") ? new IdleTracingLooperMonitor() : new BasicLooperMonitor();

        private LooperMonitorHolder() {
        }
    }

    private static final class IdleTracingLooperMonitor
    extends BasicLooperMonitor
    implements MessageQueue.IdleHandler {
        private static final String TAG = "TraceEvent_LooperMonitor";
        private static final String IDLE_EVENT_NAME = "Looper.queueIdle";
        private static final long FRAME_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_BURST_DURATION_MILLIS = 48L;
        private long mLastIdleStartedAt;
        private long mLastWorkStartedAt;
        private int mNumTasksSeen;
        private int mNumIdlesSeen;
        private int mNumTasksSinceLastIdle;
        private boolean mIdleMonitorAttached;

        private IdleTracingLooperMonitor() {
        }

        private final void syncIdleMonitoring() {
            if (sEnabled && !this.mIdleMonitorAttached) {
                this.mLastIdleStartedAt = TimeUtils.elapsedRealtimeMillis();
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
                this.mIdleMonitorAttached = true;
                android.util.Log.v((String)TAG, (String)"attached idle handler");
            } else if (this.mIdleMonitorAttached && !sEnabled) {
                Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
                this.mIdleMonitorAttached = false;
                android.util.Log.v((String)TAG, (String)"detached idle handler");
            }
        }

        @Override
        final void beginHandling(String line) {
            if (this.mNumTasksSinceLastIdle == 0) {
                TraceEvent.end(IDLE_EVENT_NAME);
            }
            this.mLastWorkStartedAt = TimeUtils.elapsedRealtimeMillis();
            this.syncIdleMonitoring();
            super.beginHandling(line);
        }

        @Override
        final void endHandling(String line) {
            long elapsed = TimeUtils.elapsedRealtimeMillis() - this.mLastWorkStartedAt;
            if (elapsed > 16L) {
                IdleTracingLooperMonitor.traceAndLog(5, "observed a task that took " + elapsed + "ms: " + line);
            }
            super.endHandling(line);
            this.syncIdleMonitoring();
            ++this.mNumTasksSeen;
            ++this.mNumTasksSinceLastIdle;
        }

        private static void traceAndLog(int level, String message) {
            TraceEvent.instant("TraceEvent.LooperMonitor:IdleStats", message);
            android.util.Log.println((int)level, (String)TAG, (String)message);
        }

        public final boolean queueIdle() {
            long now = TimeUtils.elapsedRealtimeMillis();
            if (this.mLastIdleStartedAt == 0L) {
                this.mLastIdleStartedAt = now;
            }
            long elapsed = now - this.mLastIdleStartedAt;
            ++this.mNumIdlesSeen;
            TraceEvent.begin(IDLE_EVENT_NAME, this.mNumTasksSinceLastIdle + " tasks since last idle.");
            if (elapsed > 48L) {
                String statsString = this.mNumTasksSeen + " tasks and " + this.mNumIdlesSeen + " idles processed so far, " + this.mNumTasksSinceLastIdle + " tasks bursted and " + elapsed + "ms elapsed since last idle";
                IdleTracingLooperMonitor.traceAndLog(3, statsString);
            }
            this.mLastIdleStartedAt = now;
            this.mNumTasksSinceLastIdle = 0;
            return true;
        }
    }

    @VisibleForTesting(otherwise=2)
    static class BasicLooperMonitor
    implements Printer {
        @VisibleForTesting(otherwise=2)
        static final String LOOPER_TASK_PREFIX = "Looper.dispatch: ";
        @VisibleForTesting(otherwise=2)
        static final String FILTERED_EVENT_NAME = "Looper.dispatch: EVENT_NAME_FILTERED";
        private static final int SHORTEST_LOG_PREFIX_LENGTH = "<<<<< Finished to ".length();
        private String mCurrentTarget;

        BasicLooperMonitor() {
        }

        public void println(String line) {
            if (line.startsWith(">")) {
                this.beginHandling(line);
            } else {
                assert (line.startsWith("<"));
                this.endHandling(line);
            }
        }

        void beginHandling(String line) {
            boolean earlyTracingActive = EarlyTraceEvent.enabled();
            if (sEnabled || earlyTracingActive) {
                this.mCurrentTarget = BasicLooperMonitor.getTraceEventName(line);
                if (sEnabled) {
                    TraceEventJni.get().beginToplevel(this.mCurrentTarget);
                } else {
                    EarlyTraceEvent.begin(this.mCurrentTarget, true);
                }
            }
        }

        void endHandling(String line) {
            boolean earlyTracingActive = EarlyTraceEvent.enabled();
            if ((sEnabled || earlyTracingActive) && this.mCurrentTarget != null) {
                if (sEnabled) {
                    TraceEventJni.get().endToplevel(this.mCurrentTarget);
                } else {
                    EarlyTraceEvent.end(this.mCurrentTarget, true);
                }
            }
            this.mCurrentTarget = null;
        }

        @VisibleForTesting(otherwise=2)
        static String getTraceEventName(String line) {
            if (sEventNameFilteringEnabled) {
                return FILTERED_EVENT_NAME;
            }
            return LOOPER_TASK_PREFIX + BasicLooperMonitor.getTarget(line) + "(" + BasicLooperMonitor.getTargetName(line) + ")";
        }

        private static String getTarget(String logLine) {
            int start = logLine.indexOf(40, SHORTEST_LOG_PREFIX_LENGTH);
            int end = start == -1 ? -1 : logLine.indexOf(41, start);
            return end != -1 ? logLine.substring(start + 1, end) : "";
        }

        private static String getTargetName(String logLine) {
            int end;
            int start = logLine.indexOf(125, SHORTEST_LOG_PREFIX_LENGTH);
            int n = end = start == -1 ? -1 : logLine.indexOf(58, start);
            if (end == -1) {
                end = logLine.length();
            }
            return start != -1 ? logLine.substring(start + 2, end) : "";
        }
    }

    private static class ATrace
    implements MessageQueue.IdleHandler {
        private static final String TAG = "ATrace";
        private Class<?> mTraceClass;
        private Method mIsTraceTagEnabledMethod;
        private Method mTraceBeginMethod;
        private Method mTraceEndMethod;
        private Method mAsyncTraceBeginMethod;
        private Method mAsyncTraceEndMethod;
        private Class<?> mSystemPropertiesClass;
        private Method mGetSystemPropertyMethod;
        private final AtomicBoolean mNativeTracingReady = new AtomicBoolean();
        private final AtomicBoolean mUiThreadReady = new AtomicBoolean();
        private final AtomicBoolean mTraceTagActive = new AtomicBoolean();
        private final long mTraceTag;
        private boolean mShouldWriteToSystemTrace;
        private boolean mIdleHandlerRegistered;

        public ATrace(long traceTag) {
            try {
                this.mTraceClass = Class.forName("android.os.Trace");
                this.mIsTraceTagEnabledMethod = this.mTraceClass.getMethod("isTagEnabled", Long.TYPE);
                this.mTraceBeginMethod = this.mTraceClass.getMethod("traceBegin", Long.TYPE, String.class);
                this.mTraceEndMethod = this.mTraceClass.getMethod("traceEnd", Long.TYPE);
                this.mAsyncTraceBeginMethod = this.mTraceClass.getMethod("asyncTraceBegin", Long.TYPE, String.class, Integer.TYPE);
                this.mAsyncTraceEndMethod = this.mTraceClass.getMethod("asyncTraceEnd", Long.TYPE, String.class, Integer.TYPE);
                this.mSystemPropertiesClass = Class.forName("android.os.SystemProperties");
                this.mGetSystemPropertyMethod = this.mSystemPropertiesClass.getMethod("get", String.class);
            }
            catch (Exception e) {
                Log.w(TAG, "Reflection error", e);
                this.mIsTraceTagEnabledMethod = null;
            }
            this.mTraceTag = traceTag;
            this.pollConfig();
        }

        @Nullable
        private String getSystemProperty(String name) {
            try {
                return (String)this.mGetSystemPropertyMethod.invoke(this.mSystemPropertiesClass, name);
            }
            catch (Exception e) {
                return null;
            }
        }

        private Integer getIntegerSystemProperty(String name) {
            String property = this.getSystemProperty(name);
            if (property == null) {
                return null;
            }
            try {
                return Integer.decode(property);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private boolean isTraceTagEnabled(long traceTag) {
            try {
                return (Boolean)this.mIsTraceTagEnabledMethod.invoke(this.mTraceClass, traceTag);
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean hasActiveSession() {
            return this.mTraceTagActive.get();
        }

        @UiThread
        private boolean pollConfig() {
            boolean traceTagIsActive;
            boolean traceTagWasActive = this.mTraceTagActive.get();
            if (traceTagWasActive == (traceTagIsActive = this.isTraceTagEnabled(this.mTraceTag))) {
                return false;
            }
            this.mTraceTagActive.set(traceTagIsActive);
            if (!traceTagIsActive) {
                EarlyTraceEvent.disable();
                this.disableNativeATrace();
                this.mShouldWriteToSystemTrace = false;
                ThreadUtils.getUiThreadLooper().setMessageLogging(null);
                return true;
            }
            CategoryConfig config = this.getCategoryConfigFromATrace();
            this.mShouldWriteToSystemTrace = false;
            if (this.mNativeTracingReady.get()) {
                if (config.shouldWriteToATrace) {
                    this.enableNativeATrace(config.filter);
                } else {
                    this.setupATraceStartupTrace(config.filter);
                }
            } else if (config.shouldWriteToATrace) {
                this.mShouldWriteToSystemTrace = true;
            } else {
                EarlyTraceEvent.enable();
            }
            if (!config.shouldWriteToATrace) {
                ThreadUtils.getUiThreadLooper().setMessageLogging((Printer)LooperMonitorHolder.sInstance);
            }
            return true;
        }

        private CategoryConfig getCategoryConfigFromATrace() {
            CategoryConfig config = new CategoryConfig();
            boolean shouldWriteToATrace = true;
            Integer appCount = this.getIntegerSystemProperty("debug.atrace.app_number");
            if (appCount != null && appCount > 0 && ContextUtils.getApplicationContext() != null) {
                String packageName = ContextUtils.getApplicationContext().getPackageName();
                for (int i = 0; i < appCount; ++i) {
                    String extra;
                    String appConfig = this.getSystemProperty("debug.atrace.app_" + i);
                    if (appConfig == null || !appConfig.startsWith(packageName) || !(extra = appConfig.substring(packageName.length())).startsWith("/")) continue;
                    for (String category : extra.substring(1).split(":")) {
                        if (category.equals("-atrace")) {
                            config.shouldWriteToATrace = false;
                            continue;
                        }
                        if (config.filter.length() > 0) {
                            config.filter = config.filter + ",";
                        }
                        config.filter = config.filter + category;
                    }
                }
            }
            return config;
        }

        @AnyThread
        public void onNativeTracingReady() {
            this.mNativeTracingReady.set(true);
            this.mTraceTagActive.set(false);
            if (this.mUiThreadReady.get()) {
                ThreadUtils.postOnUiThread(() -> this.pollConfig());
            }
        }

        @AnyThread
        public void onUiThreadReady() {
            this.mUiThreadReady.set(true);
            if (!ThreadUtils.runningOnUiThread()) {
                ThreadUtils.postOnUiThread(() -> this.startPolling());
                return;
            }
            this.startPolling();
        }

        private void startPolling() {
            ThreadUtils.assertOnUiThread();
            if (!this.mIdleHandlerRegistered) {
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
                this.mIdleHandlerRegistered = true;
            }
            this.pollConfig();
        }

        public final boolean queueIdle() {
            this.pollConfig();
            return true;
        }

        private void enableNativeATrace(String categoryFilter) {
            assert (this.mNativeTracingReady.get());
            TraceEventJni.get().startATrace(categoryFilter);
        }

        private void disableNativeATrace() {
            assert (this.mNativeTracingReady.get());
            TraceEventJni.get().stopATrace();
        }

        private void setupATraceStartupTrace(String categoryFilter) {
            assert (this.mNativeTracingReady.get());
            TraceEventJni.get().setupATraceStartupTrace(categoryFilter);
        }

        public void traceBegin(String name) {
            if (!this.mShouldWriteToSystemTrace) {
                return;
            }
            try {
                this.mTraceBeginMethod.invoke(this.mTraceClass, this.mTraceTag, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void traceEnd() {
            if (!this.mShouldWriteToSystemTrace) {
                return;
            }
            try {
                this.mTraceEndMethod.invoke(this.mTraceClass, this.mTraceTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void asyncTraceBegin(String name, int cookie) {
            if (!this.mShouldWriteToSystemTrace) {
                return;
            }
            try {
                this.mAsyncTraceBeginMethod.invoke(this.mTraceClass, this.mTraceTag, name, cookie);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void asyncTraceEnd(String name, int cookie) {
            if (!this.mShouldWriteToSystemTrace) {
                return;
            }
            try {
                this.mAsyncTraceEndMethod.invoke(this.mTraceClass, this.mTraceTag, name, cookie);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static class CategoryConfig {
            public String filter = "";
            public boolean shouldWriteToATrace = true;

            private CategoryConfig() {
            }
        }
    }
}

