/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.CalledByNative;

public class ThreadUtils {
    private static final Object sLock = new Object();
    private static boolean sWillOverride;
    private static Handler sUiThreadHandler;
    private static boolean sThreadAssertsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWillOverrideUiThread(boolean willOverrideUiThread) {
        Object object = sLock;
        synchronized (object) {
            sWillOverride = willOverrideUiThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUiThread(Looper looper) {
        Object object = sLock;
        synchronized (object) {
            if (looper == null) {
                sUiThreadHandler = null;
                return;
            }
            if (sUiThreadHandler != null && sUiThreadHandler.getLooper() != looper) {
                throw new RuntimeException("UI thread looper is already set to " + sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + looper);
            }
            sUiThreadHandler = new Handler(looper);
        }
        TraceEvent.onUiThreadReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler getUiThreadHandler() {
        boolean createdHandler = false;
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                if (sWillOverride) {
                    throw new RuntimeException("Did not yet override the UI thread");
                }
                sUiThreadHandler = new Handler(Looper.getMainLooper());
                createdHandler = true;
            }
        }
        if (createdHandler) {
            TraceEvent.onUiThreadReady();
        }
        return sUiThreadHandler;
    }

    @Deprecated
    public static void runOnUiThreadBlocking(Runnable r) {
        if (ThreadUtils.runningOnUiThread()) {
            r.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(r, null);
            ThreadUtils.postOnUiThread(task);
            try {
                task.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while waiting for runnable", e);
            }
        }
    }

    @Deprecated
    public static <T> T runOnUiThreadBlockingNoException(Callable<T> c) {
        try {
            return ThreadUtils.runOnUiThreadBlocking(c);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error occurred waiting for callable", e);
        }
    }

    @Deprecated
    public static <T> T runOnUiThreadBlocking(Callable<T> c) throws ExecutionException {
        FutureTask<T> task = new FutureTask<T>(c);
        ThreadUtils.runOnUiThread(task);
        try {
            return task.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for callable", e);
        }
    }

    @Deprecated
    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> task) {
        if (ThreadUtils.runningOnUiThread()) {
            task.run();
        } else {
            ThreadUtils.postOnUiThread(task);
        }
        return task;
    }

    @Deprecated
    public static <T> FutureTask<T> runOnUiThread(Callable<T> c) {
        return ThreadUtils.runOnUiThread(new FutureTask<T>(c));
    }

    @Deprecated
    public static void runOnUiThread(Runnable r) {
        if (ThreadUtils.runningOnUiThread()) {
            r.run();
        } else {
            ThreadUtils.getUiThreadHandler().post(r);
        }
    }

    @Deprecated
    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> task) {
        ThreadUtils.getUiThreadHandler().post(task);
        return task;
    }

    @Deprecated
    public static void postOnUiThread(Runnable task) {
        ThreadUtils.getUiThreadHandler().post(task);
    }

    @Deprecated
    public static void postOnUiThreadDelayed(Runnable task, long delayMillis) {
        ThreadUtils.getUiThreadHandler().postDelayed(task, delayMillis);
    }

    public static void assertOnUiThread() {
        if (sThreadAssertsDisabled) {
            return;
        }
        assert (ThreadUtils.runningOnUiThread()) : "Must be called on the UI thread.";
    }

    public static void checkUiThread() {
        if (!sThreadAssertsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Must be called on the UI thread.");
        }
    }

    public static void assertOnBackgroundThread() {
        if (sThreadAssertsDisabled) {
            return;
        }
        assert (!ThreadUtils.runningOnUiThread()) : "Must be called on a thread other than UI.";
    }

    public static void setThreadAssertsDisabledForTesting(boolean disabled) {
        sThreadAssertsDisabled = disabled;
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static Looper getUiThreadLooper() {
        return ThreadUtils.getUiThreadHandler().getLooper();
    }

    @CalledByNative
    public static void setThreadPriorityAudio(int tid) {
        Process.setThreadPriority((int)tid, (int)-16);
    }

    @CalledByNative
    private static boolean isThreadPriorityAudio(int tid) {
        return Process.getThreadPriority((int)tid) == -16;
    }

    public static class ThreadChecker {
        private final long mThreadId = Process.myTid();

        public void assertOnValidThread() {
            assert (sThreadAssertsDisabled || this.mThreadId == (long)Process.myTid()) : "Must only be used on a single thread.";
        }
    }
}

