/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.ApplicationStatusJni;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.build.BuildConfig;

@JNINamespace(value="base::android")
public class ApplicationStatus {
    private static final String TOOLBAR_CALLBACK_WRAPPER_CLASS = "androidx.appcompat.app.ToolbarActionBar$ToolbarCallbackWrapper";
    private static final Map<Activity, ActivityInfo> sActivityInfo = Collections.synchronizedMap(new HashMap());
    @SuppressLint(value={"SupportAnnotationUsage"})
    @GuardedBy(value="sActivityInfo")
    private static int sCurrentApplicationState = 0;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Activity sActivity;
    private static ApplicationStateListener sNativeApplicationStateListener;
    private static ObserverList<ActivityStateListener> sGeneralActivityStateListeners;
    private static ObserverList<ApplicationStateListener> sApplicationStateListeners;
    private static ObserverList<WindowFocusChangedListener> sWindowFocusListeners;

    private ApplicationStatus() {
    }

    @MainThread
    public static void registerWindowFocusChangedListener(WindowFocusChangedListener listener) {
        assert (ApplicationStatus.isInitialized());
        if (sWindowFocusListeners == null) {
            sWindowFocusListeners = new ObserverList();
        }
        sWindowFocusListeners.addObserver(listener);
    }

    @MainThread
    public static void unregisterWindowFocusChangedListener(WindowFocusChangedListener listener) {
        if (sWindowFocusListeners == null) {
            return;
        }
        sWindowFocusListeners.removeObserver(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void initialize(Application application) {
        assert (!ApplicationStatus.isInitialized());
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            sCurrentApplicationState = 4;
        }
        ApplicationStatus.registerWindowFocusChangedListener(new WindowFocusChangedListener(){

            @Override
            public void onWindowFocusChanged(Activity activity, boolean hasFocus) {
                if (!hasFocus || activity == sActivity) {
                    return;
                }
                int state = ApplicationStatus.getStateForActivity(activity);
                if (state != 6 && state != 5) {
                    sActivity = activity;
                }
            }
        });
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ApplicationStatus.onStateChange(activity, 1);
                Window.Callback callback = activity.getWindow().getCallback();
                activity.getWindow().setCallback(ApplicationStatus.createWindowCallbackProxy(activity, callback));
            }

            public void onActivityDestroyed(Activity activity) {
                ApplicationStatus.onStateChange(activity, 6);
                this.checkCallback(activity);
            }

            public void onActivityPaused(Activity activity) {
                ApplicationStatus.onStateChange(activity, 4);
                this.checkCallback(activity);
            }

            public void onActivityResumed(Activity activity) {
                ApplicationStatus.onStateChange(activity, 3);
                this.checkCallback(activity);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                this.checkCallback(activity);
            }

            public void onActivityStarted(Activity activity) {
                ApplicationStatus.onStateChange(activity, 2);
                this.checkCallback(activity);
            }

            public void onActivityStopped(Activity activity) {
                ApplicationStatus.onStateChange(activity, 5);
                this.checkCallback(activity);
            }

            private void checkCallback(Activity activity) {
                if (BuildConfig.ENABLE_ASSERTS) assert (ApplicationStatus.reachesWindowCallback(activity.getWindow().getCallback()));
            }
        });
    }

    @VisibleForTesting
    static Window.Callback createWindowCallbackProxy(Activity activity, Window.Callback callback) {
        return (Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new WindowCallbackProxy(activity, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static boolean reachesWindowCallback(@Nullable Window.Callback callback) {
        if (callback == null) {
            return false;
        }
        if (callback.getClass().getName().equals(TOOLBAR_CALLBACK_WRAPPER_CLASS)) {
            return true;
        }
        if (Proxy.isProxyClass(callback.getClass())) {
            return Proxy.getInvocationHandler(callback) instanceof WindowCallbackProxy;
        }
        for (Class<?> c = callback.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                Window.Callback fieldCb;
                if (!f.getType().isAssignableFrom(Window.Callback.class)) continue;
                boolean isAccessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    fieldCb = (Window.Callback)f.get(callback);
                }
                catch (IllegalAccessException ex) {
                    continue;
                }
                finally {
                    f.setAccessible(isAccessible);
                }
                if (!ApplicationStatus.reachesWindowCallback(fieldCb)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onStateChange(Activity activity, int newState) {
        int applicationState;
        ActivityInfo info;
        if (activity == null) {
            throw new IllegalArgumentException("null activity is not supported");
        }
        if (sActivity == null || newState == 1 || newState == 3 || newState == 2) {
            sActivity = activity;
        }
        int oldApplicationState = ApplicationStatus.getStateForApplication();
        Iterator<ActivityStateListener> iterator = sActivityInfo;
        synchronized (iterator) {
            if (newState == 1) {
                assert (!sActivityInfo.containsKey(activity));
                sActivityInfo.put(activity, new ActivityInfo());
            }
            info = sActivityInfo.get(activity);
            info.setStatus(newState);
            if (newState == 6) {
                sActivityInfo.remove(activity);
                if (activity == sActivity) {
                    sActivity = null;
                }
            }
            sCurrentApplicationState = ApplicationStatus.determineApplicationStateLocked();
        }
        for (ActivityStateListener listener : info.getListeners()) {
            listener.onActivityStateChange(activity, newState);
        }
        if (sGeneralActivityStateListeners != null) {
            for (ActivityStateListener listener : sGeneralActivityStateListeners) {
                listener.onActivityStateChange(activity, newState);
            }
        }
        if ((applicationState = ApplicationStatus.getStateForApplication()) != oldApplicationState && sApplicationStateListeners != null) {
            for (ApplicationStateListener listener : sApplicationStateListeners) {
                listener.onApplicationStateChange(applicationState);
            }
        }
    }

    @VisibleForTesting
    @MainThread
    public static void onStateChangeForTesting(Activity activity, int newState) {
        ApplicationStatus.onStateChange(activity, newState);
    }

    @MainThread
    public static Activity getLastTrackedFocusedActivity() {
        return sActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static List<Activity> getRunningActivities() {
        assert (ApplicationStatus.isInitialized());
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return new ArrayList<Activity>(sActivityInfo.keySet());
        }
    }

    @AnyThread
    public static int getStateForActivity(@Nullable Activity activity) {
        assert (ApplicationStatus.isInitialized());
        if (activity == null) {
            return 6;
        }
        ActivityInfo info = sActivityInfo.get(activity);
        return info != null ? info.getStatus() : 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @CalledByNative
    public static int getStateForApplication() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState;
        }
    }

    @AnyThread
    @CalledByNative
    public static boolean hasVisibleActivities() {
        assert (ApplicationStatus.isInitialized());
        int state = ApplicationStatus.getStateForApplication();
        return state == 1 || state == 2;
    }

    @AnyThread
    public static boolean isEveryActivityDestroyed() {
        assert (ApplicationStatus.isInitialized());
        return sActivityInfo.isEmpty();
    }

    @MainThread
    public static void registerStateListenerForAllActivities(ActivityStateListener listener) {
        assert (ApplicationStatus.isInitialized());
        if (sGeneralActivityStateListeners == null) {
            sGeneralActivityStateListeners = new ObserverList();
        }
        sGeneralActivityStateListeners.addObserver(listener);
    }

    @MainThread
    @SuppressLint(value={"NewApi"})
    public static void registerStateListenerForActivity(ActivityStateListener listener, Activity activity) {
        assert (ApplicationStatus.isInitialized());
        assert (activity != null);
        ActivityInfo info = sActivityInfo.get(activity);
        assert (info.getStatus() != 6);
        info.getListeners().addObserver(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void unregisterActivityStateListener(ActivityStateListener listener) {
        if (sGeneralActivityStateListeners != null) {
            sGeneralActivityStateListeners.removeObserver(listener);
        }
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            for (ActivityInfo info : sActivityInfo.values()) {
                info.getListeners().removeObserver(listener);
            }
        }
    }

    @MainThread
    public static void registerApplicationStateListener(ApplicationStateListener listener) {
        if (sApplicationStateListeners == null) {
            sApplicationStateListeners = new ObserverList();
        }
        sApplicationStateListeners.addObserver(listener);
    }

    @MainThread
    public static void unregisterApplicationStateListener(ApplicationStateListener listener) {
        if (sApplicationStateListeners == null) {
            return;
        }
        sApplicationStateListeners.removeObserver(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void destroyForJUnitTests() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            if (sApplicationStateListeners != null) {
                sApplicationStateListeners.clear();
            }
            if (sGeneralActivityStateListeners != null) {
                sGeneralActivityStateListeners.clear();
            }
            sActivityInfo.clear();
            if (sWindowFocusListeners != null) {
                sWindowFocusListeners.clear();
            }
            sCurrentApplicationState = 0;
            sActivity = null;
            sNativeApplicationStateListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void resetActivitiesForInstrumentationTests() {
        assert (ThreadUtils.runningOnUiThread());
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            for (Activity activity : new HashSet<Activity>(sActivityInfo.keySet())) {
                assert (activity.getApplication() == null) : "Real activities that are launched should be closed by test code and not rely on this cleanup of mocks.";
                ApplicationStatus.onStateChangeForTesting(activity, 6);
            }
        }
    }

    @CalledByNative
    private static void registerThreadSafeNativeApplicationStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sNativeApplicationStateListener != null) {
                    return;
                }
                sNativeApplicationStateListener = new ApplicationStateListener(){

                    @Override
                    public void onApplicationStateChange(int newState) {
                        ApplicationStatusJni.get().onApplicationStateChange(newState);
                    }
                };
                ApplicationStatus.registerApplicationStateListener(sNativeApplicationStateListener);
            }
        });
    }

    @GuardedBy(value="sActivityInfo")
    private static int determineApplicationStateLocked() {
        boolean hasPausedActivity = false;
        boolean hasStoppedActivity = false;
        for (ActivityInfo info : sActivityInfo.values()) {
            int state = info.getStatus();
            if (state != 4 && state != 5 && state != 6) {
                return 1;
            }
            if (state == 4) {
                hasPausedActivity = true;
                continue;
            }
            if (state != 5) continue;
            hasStoppedActivity = true;
        }
        if (hasPausedActivity) {
            return 2;
        }
        if (hasStoppedActivity) {
            return 3;
        }
        return 4;
    }

    static interface Natives {
        public void onApplicationStateChange(int var1);
    }

    @VisibleForTesting
    static class WindowCallbackProxy
    implements InvocationHandler {
        private final Window.Callback mCallback;
        private final Activity mActivity;

        public WindowCallbackProxy(Activity activity, Window.Callback callback) {
            this.mCallback = callback;
            this.mActivity = activity;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("onWindowFocusChanged") && args.length == 1 && args[0] instanceof Boolean) {
                this.onWindowFocusChanged((Boolean)args[0]);
                return null;
            }
            try {
                return method.invoke((Object)this.mCallback, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AbstractMethodError) {
                    throw e.getCause();
                }
                throw e;
            }
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            this.mCallback.onWindowFocusChanged(hasFocus);
            if (sWindowFocusListeners != null) {
                for (WindowFocusChangedListener listener : sWindowFocusListeners) {
                    listener.onWindowFocusChanged(this.mActivity, hasFocus);
                }
            }
        }
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }

    public static interface ActivityStateListener {
        public void onActivityStateChange(Activity var1, int var2);
    }

    public static interface ApplicationStateListener {
        public void onApplicationStateChange(int var1);
    }

    private static class ActivityInfo {
        private int mStatus = 6;
        private ObserverList<ActivityStateListener> mListeners = new ObserverList();

        private ActivityInfo() {
        }

        public int getStatus() {
            return this.mStatus;
        }

        public void setStatus(int status) {
            this.mStatus = status;
        }

        public ObserverList<ActivityStateListener> getListeners() {
            return this.mListeners;
        }
    }
}

