/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.util.Locale;
import org.chromium.net.impl.ImplVersion;

public final class UserAgent {
    private static final Object sLock = new Object();
    private static final int VERSION_CODE_UNINITIALIZED = 0;
    private static int sVersionCode = 0;

    private UserAgent() {
    }

    public static String from(Context context) {
        String id;
        StringBuilder builder = new StringBuilder();
        builder.append(context.getPackageName());
        builder.append('/');
        builder.append(UserAgent.versionFromContext(context));
        builder.append(" (Linux; U; Android ");
        builder.append(Build.VERSION.RELEASE);
        builder.append("; ");
        builder.append(Locale.getDefault().toString());
        String model = Build.MODEL;
        if (model.length() > 0) {
            builder.append("; ");
            builder.append(model);
        }
        if ((id = Build.ID).length() > 0) {
            builder.append("; Build/");
            builder.append(id);
        }
        builder.append(";");
        UserAgent.appendCronetVersion(builder);
        builder.append(')');
        return builder.toString();
    }

    static String getQuicUserAgentIdFrom(Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append(context.getPackageName());
        UserAgent.appendCronetVersion(builder);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int versionFromContext(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sVersionCode == 0) {
                PackageManager packageManager = context.getPackageManager();
                String packageName = context.getPackageName();
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
                    sVersionCode = packageInfo.versionCode;
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new IllegalStateException("Cannot determine package version");
                }
            }
            return sVersionCode;
        }
    }

    private static void appendCronetVersion(StringBuilder builder) {
        builder.append(" Cronet/");
        builder.append(ImplVersion.getCronetVersion());
    }
}

