/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.chromium.net.impl.JavaUrlRequestUtils;

public abstract class JavaUploadDataSinkBase
extends UploadDataSink {
    public static final int DEFAULT_UPLOAD_BUFFER_SIZE = 8192;
    private final AtomicInteger mSinkState = new AtomicInteger(3);
    private final Executor mUserUploadExecutor;
    private final Executor mExecutor;
    private final UploadDataProvider mUploadProvider;
    private ByteBuffer mBuffer;
    private long mTotalBytes;
    private long mWrittenBytes;

    public JavaUploadDataSinkBase(final Executor userExecutor, Executor executor, UploadDataProvider provider) {
        this.mUserUploadExecutor = new Executor(){

            @Override
            public void execute(Runnable runnable) {
                try {
                    userExecutor.execute(runnable);
                }
                catch (RejectedExecutionException e) {
                    JavaUploadDataSinkBase.this.processUploadError(e);
                }
            }
        };
        this.mExecutor = executor;
        this.mUploadProvider = provider;
    }

    public void onReadSucceeded(final boolean finalChunk) {
        if (!this.mSinkState.compareAndSet(0, 2)) {
            throw new IllegalStateException("onReadSucceeded() called when not awaiting a read result; in state: " + this.mSinkState.get());
        }
        this.mExecutor.execute(this.getErrorSettingRunnable(new JavaUrlRequestUtils.CheckedRunnable(){

            @Override
            public void run() throws Exception {
                JavaUploadDataSinkBase.this.mBuffer.flip();
                if (JavaUploadDataSinkBase.this.mTotalBytes != -1L && JavaUploadDataSinkBase.this.mTotalBytes - JavaUploadDataSinkBase.this.mWrittenBytes < (long)JavaUploadDataSinkBase.this.mBuffer.remaining()) {
                    JavaUploadDataSinkBase.this.processUploadError(new IllegalArgumentException(String.format(Locale.getDefault(), "Read upload data length %d exceeds expected length %d", JavaUploadDataSinkBase.this.mWrittenBytes + (long)JavaUploadDataSinkBase.this.mBuffer.remaining(), JavaUploadDataSinkBase.this.mTotalBytes)));
                    return;
                }
                JavaUploadDataSinkBase.this.mWrittenBytes += (long)JavaUploadDataSinkBase.this.processSuccessfulRead(JavaUploadDataSinkBase.this.mBuffer);
                if (JavaUploadDataSinkBase.this.mWrittenBytes < JavaUploadDataSinkBase.this.mTotalBytes || JavaUploadDataSinkBase.this.mTotalBytes == -1L && !finalChunk) {
                    JavaUploadDataSinkBase.this.mBuffer.clear();
                    JavaUploadDataSinkBase.this.mSinkState.set(0);
                    JavaUploadDataSinkBase.this.executeOnUploadExecutor(new JavaUrlRequestUtils.CheckedRunnable(){

                        @Override
                        public void run() throws Exception {
                            JavaUploadDataSinkBase.this.mUploadProvider.read((UploadDataSink)JavaUploadDataSinkBase.this, JavaUploadDataSinkBase.this.mBuffer);
                        }
                    });
                } else if (JavaUploadDataSinkBase.this.mTotalBytes == -1L) {
                    JavaUploadDataSinkBase.this.finish();
                } else if (JavaUploadDataSinkBase.this.mTotalBytes == JavaUploadDataSinkBase.this.mWrittenBytes) {
                    JavaUploadDataSinkBase.this.finish();
                } else {
                    JavaUploadDataSinkBase.this.processUploadError(new IllegalArgumentException(String.format(Locale.getDefault(), "Read upload data length %d exceeds expected length %d", JavaUploadDataSinkBase.this.mWrittenBytes, JavaUploadDataSinkBase.this.mTotalBytes)));
                }
            }
        }));
    }

    public void onRewindSucceeded() {
        if (!this.mSinkState.compareAndSet(1, 2)) {
            throw new IllegalStateException("onRewindSucceeded() called when not awaiting a rewind; in state: " + this.mSinkState.get());
        }
        this.startRead();
    }

    public void onReadError(Exception exception) {
        this.processUploadError(exception);
    }

    public void onRewindError(Exception exception) {
        this.processUploadError(exception);
    }

    private void startRead() {
        this.mExecutor.execute(this.getErrorSettingRunnable(new JavaUrlRequestUtils.CheckedRunnable(){

            @Override
            public void run() throws Exception {
                JavaUploadDataSinkBase.this.initializeRead();
                JavaUploadDataSinkBase.this.mSinkState.set(0);
                JavaUploadDataSinkBase.this.executeOnUploadExecutor(new JavaUrlRequestUtils.CheckedRunnable(){

                    @Override
                    public void run() throws Exception {
                        JavaUploadDataSinkBase.this.mUploadProvider.read((UploadDataSink)JavaUploadDataSinkBase.this, JavaUploadDataSinkBase.this.mBuffer);
                    }
                });
            }
        }));
    }

    private void executeOnUploadExecutor(JavaUrlRequestUtils.CheckedRunnable runnable) {
        try {
            this.mUserUploadExecutor.execute(this.getUploadErrorSettingRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.processUploadError(e);
        }
    }

    public void start(final boolean firstTime) {
        this.executeOnUploadExecutor(new JavaUrlRequestUtils.CheckedRunnable(){

            @Override
            public void run() throws Exception {
                JavaUploadDataSinkBase.this.mTotalBytes = JavaUploadDataSinkBase.this.mUploadProvider.getLength();
                if (JavaUploadDataSinkBase.this.mTotalBytes == 0L) {
                    JavaUploadDataSinkBase.this.finish();
                } else {
                    JavaUploadDataSinkBase.this.mBuffer = JavaUploadDataSinkBase.this.mTotalBytes > 0L && JavaUploadDataSinkBase.this.mTotalBytes < 8192L ? ByteBuffer.allocateDirect((int)JavaUploadDataSinkBase.this.mTotalBytes + 1) : ByteBuffer.allocateDirect(8192);
                    JavaUploadDataSinkBase.this.initializeStart(JavaUploadDataSinkBase.this.mTotalBytes);
                    if (firstTime) {
                        JavaUploadDataSinkBase.this.startRead();
                    } else {
                        JavaUploadDataSinkBase.this.mSinkState.set(1);
                        JavaUploadDataSinkBase.this.mUploadProvider.rewind((UploadDataSink)JavaUploadDataSinkBase.this);
                    }
                }
            }
        });
    }

    protected abstract Runnable getErrorSettingRunnable(JavaUrlRequestUtils.CheckedRunnable var1);

    protected abstract Runnable getUploadErrorSettingRunnable(JavaUrlRequestUtils.CheckedRunnable var1);

    protected abstract void processUploadError(Throwable var1);

    protected abstract int processSuccessfulRead(ByteBuffer var1) throws IOException;

    protected abstract void finish() throws IOException;

    protected abstract void initializeRead() throws IOException;

    protected abstract void initializeStart(long var1);

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SinkState {
        public static final int AWAITING_READ_RESULT = 0;
        public static final int AWAITING_REWIND_RESULT = 1;
        public static final int UPLOADING = 2;
        public static final int NOT_STARTED = 3;
    }
}

