/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import org.chromium.net.impl.CronetLogger;
import org.chromium.net.impl.CronetManifest;
import org.chromium.net.impl.NoOpLogger;

public final class CronetLoggerFactory {
    private static final int SAMPLE_RATE_PER_SECOND = 1;
    private static final CronetLogger sDefaultLogger = new NoOpLogger();
    private static CronetLogger sTestingLogger;
    private static final String CRONET_LOGGER_IMPL_CLASS = "com.google.net.cronet.telemetry.CronetLoggerImpl";

    private CronetLoggerFactory() {
    }

    public static CronetLogger createNoOpLogger() {
        return sDefaultLogger;
    }

    public static CronetLogger createLogger(Context ctx, CronetLogger.CronetSource source) {
        if (sTestingLogger != null) {
            return sTestingLogger;
        }
        if (!CronetManifest.isAppOptedInForTelemetry(ctx, source) || Build.VERSION.SDK_INT < 30) {
            return sDefaultLogger;
        }
        Class<? extends CronetLogger> cronetLoggerImplClass = CronetLoggerFactory.fetchLoggerImplClass();
        if (cronetLoggerImplClass == null) {
            return sDefaultLogger;
        }
        try {
            return cronetLoggerImplClass.getConstructor(Integer.TYPE).newInstance(1);
        }
        catch (Exception exception) {
            return sDefaultLogger;
        }
    }

    private static void setLoggerForTesting(@Nullable CronetLogger testingLogger) {
        sTestingLogger = testingLogger;
    }

    private static Class<? extends CronetLogger> fetchLoggerImplClass() {
        ClassLoader loader = CronetLoggerFactory.class.getClassLoader();
        try {
            return loader.loadClass(CRONET_LOGGER_IMPL_CLASS).asSubclass(CronetLogger.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static class SwapLoggerForTesting
    implements AutoCloseable {
        public SwapLoggerForTesting(CronetLogger testLogger) {
            CronetLoggerFactory.setLoggerForTesting(testLogger);
        }

        @Override
        public void close() {
            CronetLoggerFactory.setLoggerForTesting(null);
        }
    }
}

