/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import androidx.annotation.Nullable;
import java.util.Arrays;
import org.chromium.base.task.TaskTraitsExtensionDescriptor;

public class TaskTraits {
    public static final byte INVALID_EXTENSION_ID = 0;
    public static final int MAX_EXTENSION_ID = 4;
    public static final int EXTENSION_STORAGE_SIZE = 8;
    public static final TaskTraits BEST_EFFORT = new TaskTraits().taskPriority(0);
    public static final TaskTraits BEST_EFFORT_MAY_BLOCK = BEST_EFFORT.mayBlock();
    public static final TaskTraits USER_VISIBLE = new TaskTraits().taskPriority(1);
    public static final TaskTraits USER_VISIBLE_MAY_BLOCK = USER_VISIBLE.mayBlock();
    public static final TaskTraits USER_BLOCKING = new TaskTraits().taskPriority(2);
    public static final TaskTraits USER_BLOCKING_MAY_BLOCK = USER_BLOCKING.mayBlock();
    public static final TaskTraits CHOREOGRAPHER_FRAME = new TaskTraits();
    public static final TaskTraits THREAD_POOL;
    public static final TaskTraits THREAD_POOL_USER_BLOCKING;
    public static final TaskTraits THREAD_POOL_USER_VISIBLE;
    public static final TaskTraits THREAD_POOL_BEST_EFFORT;
    int mPriority;
    boolean mMayBlock;
    boolean mUseThreadPool;
    byte mExtensionId;
    byte[] mExtensionData;
    boolean mIsChoreographerFrame;

    private TaskTraits() {
        this.mPriority = 2;
    }

    private TaskTraits(TaskTraits other) {
        this.mPriority = other.mPriority;
        this.mMayBlock = other.mMayBlock;
        this.mUseThreadPool = other.mUseThreadPool;
        this.mExtensionId = other.mExtensionId;
        this.mExtensionData = other.mExtensionData;
    }

    public TaskTraits taskPriority(int taskPriority) {
        TaskTraits taskTraits = new TaskTraits(this);
        taskTraits.mPriority = taskPriority;
        return taskTraits;
    }

    public TaskTraits mayBlock() {
        TaskTraits taskTraits = new TaskTraits(this);
        taskTraits.mMayBlock = true;
        return taskTraits;
    }

    public TaskTraits threadPool() {
        TaskTraits taskTraits = new TaskTraits(this);
        taskTraits.mUseThreadPool = true;
        return taskTraits;
    }

    public boolean hasExtension() {
        return this.mExtensionId != 0;
    }

    public <Extension> Extension getExtension(TaskTraitsExtensionDescriptor<Extension> descriptor) {
        if (this.mExtensionId == descriptor.getId()) {
            return descriptor.fromSerializedData(this.mExtensionData);
        }
        return null;
    }

    public <Extension> TaskTraits withExtension(TaskTraitsExtensionDescriptor<Extension> descriptor, Extension extension) {
        int id2 = descriptor.getId();
        byte[] data = descriptor.toSerializedData(extension);
        assert (id2 > 0 && id2 <= 4);
        assert (data.length <= 8);
        TaskTraits taskTraits = new TaskTraits(this);
        taskTraits.mExtensionId = (byte)id2;
        taskTraits.mExtensionData = data;
        return taskTraits;
    }

    public TaskTraits withExplicitDestination() {
        if (!this.mUseThreadPool && !this.hasExtension()) {
            return this.threadPool();
        }
        return this;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TaskTraits) {
            TaskTraits other = (TaskTraits)object;
            return this.mPriority == other.mPriority && this.mMayBlock == other.mMayBlock && this.mUseThreadPool == other.mUseThreadPool && this.mExtensionId == other.mExtensionId && Arrays.equals(this.mExtensionData, other.mExtensionData) && this.mIsChoreographerFrame == other.mIsChoreographerFrame;
        }
        return false;
    }

    public int hashCode() {
        int hash = 31;
        hash = 37 * hash + this.mPriority;
        hash = 37 * hash + (this.mMayBlock ? 0 : 1);
        hash = 37 * hash + (this.mUseThreadPool ? 0 : 1);
        hash = 37 * hash + this.mExtensionId;
        hash = 37 * hash + Arrays.hashCode(this.mExtensionData);
        hash = 37 * hash + (this.mIsChoreographerFrame ? 0 : 1);
        return hash;
    }

    static {
        TaskTraits.CHOREOGRAPHER_FRAME.mIsChoreographerFrame = true;
        THREAD_POOL = new TaskTraits().threadPool().taskPriority(2);
        THREAD_POOL_USER_BLOCKING = THREAD_POOL.taskPriority(2);
        THREAD_POOL_USER_VISIBLE = THREAD_POOL.taskPriority(1);
        THREAD_POOL_BEST_EFFORT = THREAD_POOL.taskPriority(0);
    }
}

