/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.ChromeThreadPoolExecutor;
import org.chromium.base.task.DefaultTaskExecutor;
import org.chromium.base.task.PostTaskJni;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.TaskExecutor;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskRunnerImpl;
import org.chromium.base.task.TaskTraits;

@JNINamespace(value="base")
public class PostTask {
    private static final Object sPreNativeTaskRunnerLock = new Object();
    @GuardedBy(value="sPreNativeTaskRunnerLock")
    private static List<TaskRunnerImpl> sPreNativeTaskRunners = new ArrayList<TaskRunnerImpl>();
    private static volatile boolean sNativeInitialized;
    private static final Executor sPrenativeThreadPoolExecutor;
    private static volatile Executor sPrenativeThreadPoolExecutorOverride;
    private static AtomicReferenceArray<TaskExecutor> sTaskExecutors;

    private static AtomicReferenceArray<TaskExecutor> getInitialTaskExecutors() {
        AtomicReferenceArray<TaskExecutor> taskExecutors = new AtomicReferenceArray<TaskExecutor>(5);
        taskExecutors.set(0, new DefaultTaskExecutor());
        return taskExecutors;
    }

    public static TaskRunner createTaskRunner(TaskTraits taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).createTaskRunner(taskTraits);
    }

    public static SequencedTaskRunner createSequencedTaskRunner(TaskTraits taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).createSequencedTaskRunner(taskTraits);
    }

    public static SingleThreadTaskRunner createSingleThreadTaskRunner(TaskTraits taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).createSingleThreadTaskRunner(taskTraits);
    }

    public static void postTask(TaskTraits taskTraits, Runnable task) {
        PostTask.postDelayedTask(taskTraits, task, 0L);
    }

    public static void postDelayedTask(TaskTraits taskTraits, Runnable task, long delay) {
        if (!sNativeInitialized || taskTraits.mIsChoreographerFrame) {
            PostTask.getTaskExecutorForTraits(taskTraits).postDelayedTask(taskTraits, task, delay);
        } else {
            TaskTraits postedTraits = taskTraits.withExplicitDestination();
            PostTaskJni.get().postDelayedTask(postedTraits.mPriority, postedTraits.mMayBlock, postedTraits.mUseThreadPool, postedTraits.mExtensionId, postedTraits.mExtensionData, task, delay, task.getClass().getName());
        }
    }

    public static void runOrPostTask(TaskTraits taskTraits, Runnable task) {
        if (PostTask.getTaskExecutorForTraits(taskTraits).canRunTaskImmediately(taskTraits)) {
            task.run();
        } else {
            PostTask.postTask(taskTraits, task);
        }
    }

    public static boolean canRunTaskImmediately(TaskTraits taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).canRunTaskImmediately(taskTraits);
    }

    @Deprecated
    public static <T> T runSynchronously(TaskTraits taskTraits, Callable<T> c) {
        return PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<T>(c));
    }

    @Deprecated
    public static void runSynchronously(TaskTraits taskTraits, Runnable r) {
        PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<Object>(r, null));
    }

    private static <T> T runSynchronouslyInternal(TaskTraits taskTraits, FutureTask<T> task) {
        PostTask.runOrPostTask(taskTraits, task);
        try {
            return task.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerTaskExecutor(int extensionId, TaskExecutor taskExecutor) {
        assert (extensionId != 0);
        assert (extensionId <= 4);
        assert (sTaskExecutors.get(extensionId) == null);
        sTaskExecutors.set(extensionId, taskExecutor);
    }

    public static void setPrenativeThreadPoolExecutorForTesting(Executor executor) {
        sPrenativeThreadPoolExecutorOverride = executor;
    }

    public static void resetPrenativeThreadPoolExecutorForTesting() {
        sPrenativeThreadPoolExecutorOverride = null;
    }

    static Executor getPrenativeThreadPoolExecutor() {
        if (sPrenativeThreadPoolExecutorOverride != null) {
            return sPrenativeThreadPoolExecutorOverride;
        }
        return sPrenativeThreadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerPreNativeTaskRunner(TaskRunnerImpl taskRunner) {
        Object object = sPreNativeTaskRunnerLock;
        synchronized (object) {
            if (sPreNativeTaskRunners == null) {
                return false;
            }
            sPreNativeTaskRunners.add(taskRunner);
            return true;
        }
    }

    private static TaskExecutor getTaskExecutorForTraits(TaskTraits traits) {
        return sTaskExecutors.get(traits.mExtensionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void onNativeSchedulerReady() {
        List<TaskRunnerImpl> preNativeTaskRunners;
        assert (!sNativeInitialized);
        sNativeInitialized = true;
        Iterator<TaskRunnerImpl> iterator = sPreNativeTaskRunnerLock;
        synchronized (iterator) {
            preNativeTaskRunners = sPreNativeTaskRunners;
            sPreNativeTaskRunners = null;
        }
        for (TaskRunnerImpl taskRunner : preNativeTaskRunners) {
            taskRunner.initNativeTaskRunner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void onNativeSchedulerShutdownForTesting() {
        Object object = sPreNativeTaskRunnerLock;
        synchronized (object) {
            sPreNativeTaskRunners = new ArrayList<TaskRunnerImpl>();
        }
        sNativeInitialized = false;
        sTaskExecutors.set(0, new DefaultTaskExecutor());
        for (int i = 1; i < sTaskExecutors.length(); ++i) {
            sTaskExecutors.set(i, null);
        }
    }

    static {
        sPrenativeThreadPoolExecutor = new ChromeThreadPoolExecutor();
        sTaskExecutors = PostTask.getInitialTaskExecutors();
    }

    static interface Natives {
        public void postDelayedTask(int var1, boolean var2, boolean var3, byte var4, byte[] var5, Runnable var6, long var7, String var9);
    }
}

