/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.supplier;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.chromium.base.Callback;
import org.chromium.base.Promise;
import org.chromium.base.ThreadUtils;
import org.chromium.base.supplier.OneshotSupplier;

public class OneshotSupplierImpl<T>
implements OneshotSupplier<T> {
    private final Promise<T> mPromise = new Promise();
    private final ThreadUtils.ThreadChecker mThreadChecker = new ThreadUtils.ThreadChecker();

    @Override
    public T onAvailable(Callback<T> callback) {
        this.mThreadChecker.assertOnValidThread();
        this.mPromise.then(callback);
        return this.get();
    }

    @Override
    @Nullable
    public T get() {
        this.mThreadChecker.assertOnValidThread();
        return this.mPromise.isFulfilled() ? (T)this.mPromise.getResult() : null;
    }

    public void set(@NonNull T object) {
        this.mThreadChecker.assertOnValidThread();
        assert (!this.mPromise.isFulfilled());
        assert (object != null);
        this.mPromise.fulfill(object);
    }
}

