/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.compat;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkRequest;
import android.os.Handler;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.autofill.AutofillManager;
import androidx.annotation.RequiresApi;
import org.chromium.base.StrictModeContext;

@RequiresApi(value=26)
public final class ApiHelperForO {
    private ApiHelperForO() {
    }

    public static boolean isWideColorGamut(Display display) {
        return display.isWideColorGamut();
    }

    public static void setColorMode(Window window, int colorMode) {
        window.setColorMode(colorMode);
    }

    public static boolean isScreenWideColorGamut(Configuration configuration) {
        return configuration.isScreenWideColorGamut();
    }

    public static boolean isInstantApp(PackageManager packageManager) {
        return packageManager.isInstantApp();
    }

    public static void setDefaultFocusHighlightEnabled(View view, boolean enabled) {
        view.setDefaultFocusHighlightEnabled(enabled);
    }

    public static long getTimestamp(ClipDescription clipDescription) {
        return clipDescription.getTimestamp();
    }

    public static String[] getSplitNames(ApplicationInfo info) {
        return info.splitNames;
    }

    public static Context createContextForSplit(Context context, String name) throws PackageManager.NameNotFoundException {
        try (StrictModeContext ignored = StrictModeContext.allowDiskReads();){
            Context context2 = context.createContextForSplit(name);
            return context2;
        }
    }

    public static void cancelAutofillSession(Activity activity) {
        AutofillManager afm = (AutofillManager)activity.getSystemService(AutofillManager.class);
        if (afm != null) {
            afm.cancel();
        }
    }

    public static void notifyValueChangedForAutofill(View view) {
        AutofillManager afm = (AutofillManager)view.getContext().getSystemService(AutofillManager.class);
        if (afm != null) {
            afm.notifyValueChanged(view);
        }
    }

    public static void registerNetworkCallback(ConnectivityManager connectivityManager, NetworkRequest networkRequest, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        connectivityManager.registerNetworkCallback(networkRequest, networkCallback, handler);
    }

    public static boolean areAnimatorsEnabled() {
        return ValueAnimator.areAnimatorsEnabled();
    }

    public static Notification.Builder setChannelId(Notification.Builder builder, String channelId) {
        return builder.setChannelId(channelId);
    }

    public static Notification.Builder setTimeoutAfter(Notification.Builder builder, long ms) {
        return builder.setTimeoutAfter(ms);
    }

    public static void registerDefaultNetworkCallback(ConnectivityManager connectivityManager, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        connectivityManager.registerDefaultNetworkCallback(networkCallback, handler);
    }

    public static String getNotificationChannelId(Notification notification) {
        return notification.getChannelId();
    }

    public static Intent registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, String permission2, Handler scheduler, int flags) {
        return context.registerReceiver(receiver, filter, permission2, scheduler, flags);
    }

    public static void addItem(ClipData clipData, ContentResolver contentResolver, ClipData.Item item) {
        clipData.addItem(contentResolver, item);
    }
}

