/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManager;
import android.os.Build;
import android.os.PowerManager;
import org.chromium.base.ContextUtils;
import org.chromium.base.PowerMonitorForQ;
import org.chromium.base.PowerMonitorJni;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.compat.ApiHelperForQ;

@JNINamespace(value="base::android")
public class PowerMonitor {
    private static PowerMonitor sInstance;
    private boolean mIsBatteryPower;

    public static void createForTests() {
        sInstance = new PowerMonitor();
    }

    public static void create() {
        PowerManager powerManager;
        ThreadUtils.assertOnUiThread();
        if (sInstance != null) {
            return;
        }
        Context context = ContextUtils.getApplicationContext();
        sInstance = new PowerMonitor();
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatusIntent = ContextUtils.registerNonExportedBroadcastReceiver(context, null, ifilter);
        if (batteryStatusIntent != null) {
            int chargePlug = batteryStatusIntent.getIntExtra("plugged", 0);
            PowerMonitor.onBatteryChargingChanged(chargePlug == 0);
        }
        IntentFilter powerConnectedFilter = new IntentFilter();
        powerConnectedFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        powerConnectedFilter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        ContextUtils.registerNonExportedBroadcastReceiver(context, new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                PowerMonitor.onBatteryChargingChanged(intent.getAction().equals("android.intent.action.ACTION_POWER_DISCONNECTED"));
            }
        }, powerConnectedFilter);
        if (Build.VERSION.SDK_INT >= 29 && (powerManager = (PowerManager)context.getSystemService("power")) != null) {
            PowerMonitorForQ.addThermalStatusListener(powerManager);
        }
    }

    private PowerMonitor() {
    }

    private static void onBatteryChargingChanged(boolean isBatteryPower) {
        assert (sInstance != null);
        PowerMonitor.sInstance.mIsBatteryPower = isBatteryPower;
        PowerMonitorJni.get().onBatteryChargingChanged();
    }

    @CalledByNative
    private static boolean isBatteryPower() {
        if (sInstance == null) {
            PowerMonitor.create();
        }
        return PowerMonitor.sInstance.mIsBatteryPower;
    }

    @CalledByNative
    private static int getRemainingBatteryCapacity() {
        if (Build.VERSION.SDK_INT < 21) {
            return 0;
        }
        if (sInstance == null) {
            PowerMonitor.create();
        }
        return PowerMonitor.getRemainingBatteryCapacityImpl();
    }

    private static int getRemainingBatteryCapacityImpl() {
        return ((BatteryManager)ContextUtils.getApplicationContext().getSystemService("batterymanager")).getIntProperty(1);
    }

    @CalledByNative
    private static int getCurrentThermalStatus() {
        PowerManager powerManager;
        if (Build.VERSION.SDK_INT < 29) {
            return -1;
        }
        if (sInstance == null) {
            PowerMonitor.create();
        }
        if ((powerManager = (PowerManager)ContextUtils.getApplicationContext().getSystemService("power")) == null) {
            return -1;
        }
        return ApiHelperForQ.getCurrentThermalStatus(powerManager);
    }

    static interface Natives {
        public void onBatteryChargingChanged();

        public void onThermalStatusChanged(int var1);
    }
}

