/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.chromium.net.CronetProvider;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.UrlRequest;

public abstract class CronetEngine {
    private static final String TAG = CronetEngine.class.getSimpleName();

    public abstract String getVersionString();

    public abstract void shutdown();

    public abstract void startNetLogToFile(String var1, boolean var2);

    public abstract void stopNetLog();

    public abstract byte[] getGlobalMetricsDeltas();

    public abstract URLConnection openConnection(URL var1) throws IOException;

    public abstract URLStreamHandlerFactory createURLStreamHandlerFactory();

    public abstract UrlRequest.Builder newUrlRequestBuilder(String var1, UrlRequest.Callback var2, Executor var3);

    public static class Builder {
        protected final ICronetEngineBuilder mBuilderDelegate;
        public static final int HTTP_CACHE_DISABLED = 0;
        public static final int HTTP_CACHE_IN_MEMORY = 1;
        public static final int HTTP_CACHE_DISK_NO_HTTP = 2;
        public static final int HTTP_CACHE_DISK = 3;

        public Builder(Context context) {
            this(Builder.createBuilderDelegate(context));
        }

        public Builder(ICronetEngineBuilder builderDelegate) {
            this.mBuilderDelegate = builderDelegate;
        }

        public String getDefaultUserAgent() {
            return this.mBuilderDelegate.getDefaultUserAgent();
        }

        public Builder setUserAgent(String userAgent) {
            this.mBuilderDelegate.setUserAgent(userAgent);
            return this;
        }

        public Builder setStoragePath(String value) {
            this.mBuilderDelegate.setStoragePath(value);
            return this;
        }

        public Builder setLibraryLoader(LibraryLoader loader) {
            this.mBuilderDelegate.setLibraryLoader(loader);
            return this;
        }

        public Builder enableQuic(boolean value) {
            this.mBuilderDelegate.enableQuic(value);
            return this;
        }

        public Builder enableHttp2(boolean value) {
            this.mBuilderDelegate.enableHttp2(value);
            return this;
        }

        @Deprecated
        public Builder enableSdch(boolean value) {
            return this;
        }

        public Builder enableBrotli(boolean value) {
            this.mBuilderDelegate.enableBrotli(value);
            return this;
        }

        public Builder enableHttpCache(int cacheMode, long maxSize) {
            this.mBuilderDelegate.enableHttpCache(cacheMode, maxSize);
            return this;
        }

        public Builder addQuicHint(String host, int port, int alternatePort) {
            this.mBuilderDelegate.addQuicHint(host, port, alternatePort);
            return this;
        }

        public Builder addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
            this.mBuilderDelegate.addPublicKeyPins(hostName, pinsSha256, includeSubdomains, expirationDate);
            return this;
        }

        public Builder enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
            this.mBuilderDelegate.enablePublicKeyPinningBypassForLocalTrustAnchors(value);
            return this;
        }

        public CronetEngine build() {
            return this.mBuilderDelegate.build();
        }

        private static ICronetEngineBuilder createBuilderDelegate(Context context) {
            ArrayList<CronetProvider> providers = new ArrayList<CronetProvider>(CronetProvider.getAllProviders(context));
            CronetProvider provider = Builder.getEnabledCronetProviders(context, providers).get(0);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)String.format("Using '%s' provider for creating CronetEngine.Builder.", provider));
            }
            return provider.createBuilder().mBuilderDelegate;
        }

        @VisibleForTesting
        static List<CronetProvider> getEnabledCronetProviders(Context context, List<CronetProvider> providers) {
            if (providers.size() == 0) {
                throw new RuntimeException("Unable to find any Cronet provider. Have you included all necessary jars?");
            }
            Iterator<CronetProvider> i = providers.iterator();
            while (i.hasNext()) {
                CronetProvider provider = i.next();
                if (provider.isEnabled()) continue;
                i.remove();
            }
            if (providers.size() == 0) {
                throw new RuntimeException("All available Cronet providers are disabled. A provider should be enabled before it can be used.");
            }
            Collections.sort(providers, new Comparator<CronetProvider>(){

                @Override
                public int compare(CronetProvider p1, CronetProvider p2) {
                    if ("Fallback-Cronet-Provider".equals(p1.getName())) {
                        return 1;
                    }
                    if ("Fallback-Cronet-Provider".equals(p2.getName())) {
                        return -1;
                    }
                    return -Builder.compareVersions(p1.getVersion(), p2.getVersion());
                }
            });
            return providers;
        }

        @VisibleForTesting
        static int compareVersions(String s1, String s2) {
            if (s1 == null || s2 == null) {
                throw new IllegalArgumentException("The input values cannot be null");
            }
            String[] s1segments = s1.split("\\.");
            String[] s2segments = s2.split("\\.");
            for (int i = 0; i < s1segments.length && i < s2segments.length; ++i) {
                try {
                    int s1segment = Integer.parseInt(s1segments[i]);
                    int s2segment = Integer.parseInt(s2segments[i]);
                    if (s1segment == s2segment) continue;
                    return Integer.signum(s1segment - s2segment);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unable to convert version segments into integers: " + s1segments[i] + " & " + s2segments[i], e);
                }
            }
            return Integer.signum(s1segments.length - s2segments.length);
        }

        public static abstract class LibraryLoader {
            public abstract void loadLibrary(String var1);
        }
    }
}

