/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.TaskRunnerImpl;
import org.chromium.base.task.TaskTraits;

@JNINamespace(value="base")
public class SingleThreadTaskRunnerImpl
extends TaskRunnerImpl
implements SingleThreadTaskRunner {
    @Nullable
    private final Handler mHandler;
    private final boolean mPostPreNativeTasksAtFrontOfQueue;

    public SingleThreadTaskRunnerImpl(Handler handler, TaskTraits traits, boolean postPreNativeTasksAtFrontOfQueue) {
        super(traits, "SingleThreadTaskRunnerImpl", 2);
        this.mHandler = handler;
        this.mPostPreNativeTasksAtFrontOfQueue = postPreNativeTasksAtFrontOfQueue;
    }

    public SingleThreadTaskRunnerImpl(Handler handler, TaskTraits traits) {
        this(handler, traits, false);
    }

    @Override
    public boolean belongsToCurrentThread() {
        Boolean belongs = this.belongsToCurrentThreadInternal();
        if (belongs != null) {
            return belongs;
        }
        assert (this.mHandler != null);
        return this.mHandler.getLooper().getThread() == Thread.currentThread();
    }

    @Override
    protected void schedulePreNativeTask() {
        if (this.mHandler == null) {
            RecordHistogram.recordEnumeratedHistogram("Android.TaskScheduling.PreNativeTaskPostType", 2, 3);
            return;
        }
        if (this.mPostPreNativeTasksAtFrontOfQueue) {
            RecordHistogram.recordEnumeratedHistogram("Android.TaskScheduling.PreNativeTaskPostType", 1, 3);
            this.postAtFrontOfQueue();
        } else {
            RecordHistogram.recordEnumeratedHistogram("Android.TaskScheduling.PreNativeTaskPostType", 0, 3);
            this.mHandler.post(this.mRunPreNativeTaskClosure);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void postAtFrontOfQueue() {
        if (Build.VERSION.SDK_INT >= 21) {
            Message message = Message.obtain((Handler)this.mHandler, (Runnable)this.mRunPreNativeTaskClosure);
            message.setAsynchronous(true);
            this.mHandler.sendMessageAtFrontOfQueue(message);
        } else {
            this.mHandler.postAtFrontOfQueue(this.mRunPreNativeTaskClosure);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PreNativeTaskPostType {
        public static final int POSTED_AT_BACK_OF_QUEUE = 0;
        public static final int POSTED_AT_FRONT_OF_QUEUE = 1;
        public static final int DEFERRED_TO_NATIVE_INIT = 2;
        public static final int NUM_ENTRIES = 3;
    }
}

