/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import org.chromium.base.JniException;
import org.chromium.build.BuildConfig;

public class NativeLibraryLoadedStatus {
    private static NativeLibraryLoadedStatusProvider sProvider;

    public static void checkLoaded(boolean isMainDex) {
        boolean nativeMethodsReady;
        if (!BuildConfig.ENABLE_ASSERTS) {
            return;
        }
        if (sProvider == null) {
            return;
        }
        boolean bl = nativeMethodsReady = isMainDex ? sProvider.areMainDexNativeMethodsReady() : sProvider.areNativeMethodsReady();
        if (!nativeMethodsReady) {
            throw new JniException("Native method called before the native library was ready.");
        }
    }

    public static void setProvider(NativeLibraryLoadedStatusProvider statusProvider) {
        sProvider = statusProvider;
    }

    public static NativeLibraryLoadedStatusProvider getProviderForTesting() {
        return sProvider;
    }

    public static interface NativeLibraryLoadedStatusProvider {
        public boolean areMainDexNativeMethodsReady();

        public boolean areNativeMethodsReady();
    }
}

