/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import org.chromium.net.CronetException;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UrlResponseInfo;

public class RequestFinishedInfoImpl
extends RequestFinishedInfo {
    private final String mUrl;
    private final Collection<Object> mAnnotations;
    private final RequestFinishedInfo.Metrics mMetrics;
    private final int mFinishedReason;
    @Nullable
    private final UrlResponseInfo mResponseInfo;
    @Nullable
    private final CronetException mException;

    public RequestFinishedInfoImpl(String url, Collection<Object> annotations, RequestFinishedInfo.Metrics metrics, int finishedReason, @Nullable UrlResponseInfo responseInfo, @Nullable CronetException exception) {
        this.mUrl = url;
        this.mAnnotations = annotations;
        this.mMetrics = metrics;
        this.mFinishedReason = finishedReason;
        this.mResponseInfo = responseInfo;
        this.mException = exception;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Collection<Object> getAnnotations() {
        if (this.mAnnotations == null) {
            return Collections.emptyList();
        }
        return this.mAnnotations;
    }

    public RequestFinishedInfo.Metrics getMetrics() {
        return this.mMetrics;
    }

    public int getFinishedReason() {
        return this.mFinishedReason;
    }

    @Nullable
    public UrlResponseInfo getResponseInfo() {
        return this.mResponseInfo;
    }

    @Nullable
    public CronetException getException() {
        return this.mException;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FinishedReason {
    }
}

