/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.chromium.base.UnownedUserData;
import org.chromium.base.UnownedUserDataHost;
import org.chromium.build.BuildConfig;

public final class UnownedUserDataKey<T extends UnownedUserData> {
    @NonNull
    private final Class<T> mClazz;
    private final Set<UnownedUserDataHost> mWeakHostAttachments = Collections.newSetFromMap(new WeakHashMap());

    public UnownedUserDataKey(@NonNull Class<T> clazz) {
        this.mClazz = clazz;
    }

    @NonNull
    final Class<T> getValueClass() {
        return this.mClazz;
    }

    public final void attachToHost(@NonNull UnownedUserDataHost host, @NonNull T object) {
        Objects.requireNonNull(object);
        host.set(this, object);
        if (!this.isAttachedToHost(host)) {
            this.mWeakHostAttachments.add(host);
        }
    }

    @Nullable
    public final T retrieveDataFromHost(@NonNull UnownedUserDataHost host) {
        this.assertNoDestroyedAttachments();
        for (UnownedUserDataHost attachedHost : this.mWeakHostAttachments) {
            if (!host.equals(attachedHost)) continue;
            return host.get(this);
        }
        return null;
    }

    public final void detachFromHost(@NonNull UnownedUserDataHost host) {
        this.assertNoDestroyedAttachments();
        for (UnownedUserDataHost attachedHost : new ArrayList<UnownedUserDataHost>(this.mWeakHostAttachments)) {
            if (!host.equals(attachedHost)) continue;
            this.removeHostAttachment(attachedHost);
        }
    }

    public final void detachFromAllHosts(@NonNull T object) {
        this.assertNoDestroyedAttachments();
        for (UnownedUserDataHost attachedHost : new ArrayList<UnownedUserDataHost>(this.mWeakHostAttachments)) {
            if (!object.equals(attachedHost.get(this))) continue;
            this.removeHostAttachment(attachedHost);
        }
    }

    public final boolean isAttachedToHost(@NonNull UnownedUserDataHost host) {
        T t = this.retrieveDataFromHost(host);
        return t != null;
    }

    public final boolean isAttachedToAnyHost(@NonNull T object) {
        return this.getHostAttachmentCount(object) > 0;
    }

    @VisibleForTesting(otherwise=2)
    int getHostAttachmentCount(@NonNull T object) {
        this.assertNoDestroyedAttachments();
        int ret = 0;
        for (UnownedUserDataHost attachedHost : this.mWeakHostAttachments) {
            if (!object.equals(attachedHost.get(this))) continue;
            ++ret;
        }
        return ret;
    }

    private void removeHostAttachment(UnownedUserDataHost host) {
        host.remove(this);
        this.mWeakHostAttachments.remove(host);
    }

    private void assertNoDestroyedAttachments() {
        if (BuildConfig.ENABLE_ASSERTS) {
            for (UnownedUserDataHost attachedHost : this.mWeakHostAttachments) {
                if (!attachedHost.isDestroyed()) continue;
                assert (false) : "Host should have been removed already.";
                throw new IllegalStateException();
            }
        }
    }
}

