/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.text.TextUtils;
import java.util.Map;
import org.chromium.base.BundleUtils;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.MainDex;

@MainDex
public class JNIUtils {
    private static Boolean sSelectiveJniRegistrationEnabled;
    private static ClassLoader sJniClassLoader;

    private static ClassLoader getClassLoader() {
        if (sJniClassLoader == null) {
            return JNIUtils.class.getClassLoader();
        }
        return sJniClassLoader;
    }

    @CalledByNative
    public static ClassLoader getSplitClassLoader(String splitName) {
        Context context = ContextUtils.getApplicationContext();
        if (!TextUtils.isEmpty((CharSequence)splitName) && BundleUtils.isIsolatedSplitInstalled(context, splitName)) {
            return BundleUtils.createIsolatedSplitContext(context, splitName).getClassLoader();
        }
        return JNIUtils.getClassLoader();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        sJniClassLoader = classLoader;
    }

    @CalledByNative
    public static boolean isSelectiveJniRegistrationEnabled() {
        if (sSelectiveJniRegistrationEnabled == null) {
            sSelectiveJniRegistrationEnabled = false;
        }
        return sSelectiveJniRegistrationEnabled;
    }

    public static void enableSelectiveJniRegistration() {
        assert (sSelectiveJniRegistrationEnabled == null);
        sSelectiveJniRegistrationEnabled = true;
    }

    public static <K, V> void splitMap(Map<K, V> map, K[] outKeys, V[] outValues) {
        assert (map.size() == outKeys.length);
        assert (outValues.length == outKeys.length);
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            outKeys[i] = entry.getKey();
            outValues[i] = entry.getValue();
            ++i;
        }
    }
}

