/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.BadParcelableException;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.TransactionTooLargeException;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.BundleCompat;
import java.io.Serializable;
import java.util.ArrayList;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.base.compat.ApiHelperForS;

public class IntentUtils {
    private static final String TAG = "IntentUtils";
    public static final String ANDROID_APP_REFERRER_SCHEME = "android-app";
    @VisibleForTesting
    public static final String EPHEMERAL_INSTALLER_CLASS = "com.google.android.gms.instantapps.routing.EphemeralInstallerActivity";
    public static final String TRUSTED_APPLICATION_CODE_EXTRA = "trusted_application_code_extra";
    private static ComponentName sFakeComponentName;
    private static final Object COMPONENT_NAME_LOCK;
    private static boolean sForceTrustedIntentForTesting;

    public static boolean isInstantAppResolveInfo(ResolveInfo info) {
        if (info == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return info.isInstantAppAvailable;
        }
        if (info.activityInfo != null) {
            return EPHEMERAL_INSTALLER_CLASS.equals(info.activityInfo.name);
        }
        return false;
    }

    public static boolean safeHasExtra(Intent intent, String name) {
        try {
            return intent.hasExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "hasExtra failed on intent " + intent, new Object[0]);
            return false;
        }
    }

    public static void safeRemoveExtra(Intent intent, String name) {
        try {
            intent.removeExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "removeExtra failed on intent " + intent, new Object[0]);
        }
    }

    public static boolean safeGetBooleanExtra(Intent intent, String name, boolean defaultValue) {
        try {
            return intent.getBooleanExtra(name, defaultValue);
        }
        catch (Throwable t) {
            Log.e(TAG, "getBooleanExtra failed on intent " + intent, new Object[0]);
            return defaultValue;
        }
    }

    public static boolean safeGetBoolean(Bundle bundle, String name, boolean defaultValue) {
        try {
            return bundle.getBoolean(name, defaultValue);
        }
        catch (Throwable t) {
            Log.e(TAG, "getBoolean failed on bundle " + bundle, new Object[0]);
            return defaultValue;
        }
    }

    public static int safeGetIntExtra(Intent intent, String name, int defaultValue) {
        try {
            return intent.getIntExtra(name, defaultValue);
        }
        catch (Throwable t) {
            Log.e(TAG, "getIntExtra failed on intent " + intent, new Object[0]);
            return defaultValue;
        }
    }

    public static int safeGetInt(Bundle bundle, String name, int defaultValue) {
        try {
            return bundle.getInt(name, defaultValue);
        }
        catch (Throwable t) {
            Log.e(TAG, "getInt failed on bundle " + bundle, new Object[0]);
            return defaultValue;
        }
    }

    public static int[] safeGetIntArrayExtra(Intent intent, String name) {
        try {
            return intent.getIntArrayExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getIntArrayExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static int[] safeGetIntArray(Bundle bundle, String name) {
        try {
            return bundle.getIntArray(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getIntArray failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static float[] safeGetFloatArray(Bundle bundle, String name) {
        try {
            return bundle.getFloatArray(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getFloatArray failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static long safeGetLongExtra(Intent intent, String name, long defaultValue) {
        try {
            return intent.getLongExtra(name, defaultValue);
        }
        catch (Throwable t) {
            Log.e(TAG, "getLongExtra failed on intent " + intent, new Object[0]);
            return defaultValue;
        }
    }

    public static String safeGetStringExtra(Intent intent, String name) {
        try {
            return intent.getStringExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getStringExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static String safeGetString(Bundle bundle, String name) {
        try {
            return bundle.getString(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getString failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static Bundle safeGetBundleExtra(Intent intent, String name) {
        try {
            return intent.getBundleExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getBundleExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static Bundle safeGetBundle(Bundle bundle, String name) {
        try {
            return bundle.getBundle(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getBundle failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static <T extends Parcelable> T safeGetParcelable(Bundle bundle, String name) {
        try {
            return (T)bundle.getParcelable(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getParcelable failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static <T extends Parcelable> T safeGetParcelableExtra(Intent intent, String name) {
        try {
            return (T)intent.getParcelableExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getParcelableExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static <T extends Parcelable> ArrayList<T> getParcelableArrayListExtra(Intent intent, String name) {
        try {
            return intent.getParcelableArrayListExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getParcelableArrayListExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static <T extends Parcelable> ArrayList<T> safeGetParcelableArrayList(Bundle bundle, String name) {
        try {
            return bundle.getParcelableArrayList(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getParcelableArrayList failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static Parcelable[] safeGetParcelableArrayExtra(Intent intent, String name) {
        try {
            return intent.getParcelableArrayExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getParcelableArrayExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static ArrayList<String> safeGetStringArrayListExtra(Intent intent, String name) {
        try {
            return intent.getStringArrayListExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getStringArrayListExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static byte[] safeGetByteArrayExtra(Intent intent, String name) {
        try {
            return intent.getByteArrayExtra(name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getByteArrayExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static <T extends Serializable> T safeGetSerializableExtra(Intent intent, String name) {
        try {
            return (T)intent.getSerializableExtra(name);
        }
        catch (ClassCastException ex) {
            Log.e(TAG, "Invalide class for Serializable: " + name, ex);
            return null;
        }
        catch (Throwable t) {
            Log.e(TAG, "getSerializableExtra failed on intent " + intent, new Object[0]);
            return null;
        }
    }

    public static IBinder safeGetBinder(Bundle bundle, String name) {
        if (bundle == null) {
            return null;
        }
        try {
            return BundleCompat.getBinder((Bundle)bundle, (String)name);
        }
        catch (Throwable t) {
            Log.e(TAG, "getBinder failed on bundle " + bundle, new Object[0]);
            return null;
        }
    }

    public static IBinder safeGetBinderExtra(Intent intent, String name) {
        if (!intent.hasExtra(name)) {
            return null;
        }
        Bundle extras = intent.getExtras();
        return IntentUtils.safeGetBinder(extras, name);
    }

    public static void safePutBinderExtra(Intent intent, String name, IBinder binder) {
        if (intent == null) {
            return;
        }
        Bundle bundle = new Bundle();
        try {
            BundleCompat.putBinder((Bundle)bundle, (String)name, (IBinder)binder);
        }
        catch (Throwable t) {
            Log.e(TAG, "putBinder failed on bundle " + bundle, new Object[0]);
        }
        intent.putExtras(bundle);
    }

    public static boolean safeStartActivity(Context context, Intent intent) {
        return IntentUtils.safeStartActivity(context, intent, null);
    }

    public static boolean safeStartActivity(Context context, Intent intent, @Nullable Bundle bundle) {
        try {
            context.startActivity(intent, bundle);
            return true;
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
    }

    public static boolean isIntentForNewTaskOrNewDocument(Intent intent) {
        int testFlags = 0x10080000;
        return (intent.getFlags() & testFlags) != 0;
    }

    public static int getParceledIntentSize(Intent intent) {
        Parcel parcel = Parcel.obtain();
        intent.writeToParcel(parcel, 0);
        return parcel.dataSize();
    }

    public static void logTransactionTooLargeOrRethrow(RuntimeException e, Intent intent) {
        if (!(e.getCause() instanceof TransactionTooLargeException)) {
            throw e;
        }
        Log.e(TAG, "Could not resolve Activity for intent " + intent.toString(), e);
    }

    private static Intent logInvalidIntent(Intent intent, Exception e) {
        Log.e(TAG, "Invalid incoming intent.", e);
        return intent.replaceExtras((Bundle)null);
    }

    public static Intent sanitizeIntent(Intent incomingIntent) {
        if (incomingIntent == null) {
            return null;
        }
        try {
            incomingIntent.getBooleanExtra("TriggerUnparcel", false);
            return incomingIntent;
        }
        catch (BadParcelableException e) {
            return IntentUtils.logInvalidIntent(incomingIntent, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                return IntentUtils.logInvalidIntent(incomingIntent, e);
            }
            throw e;
        }
    }

    public static boolean isMainIntentFromLauncher(Intent intent) {
        return intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.intent.action.MAIN") && intent.hasCategory("android.intent.category.LAUNCHER") && 0 == (intent.getFlags() & 0x100000);
    }

    public static int getPendingIntentMutabilityFlag(boolean mutable) {
        if (!mutable && Build.VERSION.SDK_INT >= 23) {
            return ApiHelperForM.getPendingIntentImmutableFlag();
        }
        if (mutable && Build.VERSION.SDK_INT >= 31) {
            return ApiHelperForS.getPendingIntentMutableFlag();
        }
        return 0;
    }

    public static boolean intentTargetsSelf(Context context, Intent intent) {
        boolean matchesComponent;
        boolean hasPackage = !TextUtils.isEmpty((CharSequence)intent.getPackage());
        boolean matchesPackage = hasPackage && context.getPackageName().equals(intent.getPackage());
        boolean hasComponent = intent.getComponent() != null;
        boolean bl = matchesComponent = hasComponent && context.getPackageName().equals(intent.getComponent().getPackageName());
        if (matchesComponent) {
            if (hasPackage) {
                assert (matchesPackage);
                return matchesPackage;
            }
            return true;
        }
        if (matchesPackage) {
            assert (!hasComponent);
            return !hasComponent;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComponentName getFakeComponentName(String packageName) {
        Object object = COMPONENT_NAME_LOCK;
        synchronized (object) {
            if (sFakeComponentName == null) {
                sFakeComponentName = new ComponentName(packageName, "FakeClass");
            }
        }
        return sFakeComponentName;
    }

    private static PendingIntent getAuthenticationToken() {
        Intent fakeIntent = new Intent();
        Context appContext = ContextUtils.getApplicationContext();
        fakeIntent.setComponent(IntentUtils.getFakeComponentName(appContext.getPackageName()));
        return PendingIntent.getActivity((Context)appContext, (int)0, (Intent)fakeIntent, (int)IntentUtils.getPendingIntentMutabilityFlag(false));
    }

    public static void addTrustedIntentExtras(Intent intent) {
        boolean toSelf = IntentUtils.intentTargetsSelf(ContextUtils.getApplicationContext(), intent);
        assert (toSelf);
        if (!toSelf) {
            return;
        }
        intent.putExtra(TRUSTED_APPLICATION_CODE_EXTRA, (Parcelable)IntentUtils.getAuthenticationToken());
    }

    public static boolean isTrustedIntentFromSelf(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        if (sForceTrustedIntentForTesting) {
            return true;
        }
        PendingIntent token = (PendingIntent)IntentUtils.safeGetParcelableExtra(intent, TRUSTED_APPLICATION_CODE_EXTRA);
        if (token == null) {
            return false;
        }
        PendingIntent pending = IntentUtils.getAuthenticationToken();
        return pending.equals((Object)token);
    }

    public static void setForceIsTrustedIntentForTesting(boolean isTrusted) {
        sForceTrustedIntentForTesting = isTrusted;
    }

    static {
        COMPONENT_NAME_LOCK = new Object();
    }
}

