/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import org.chromium.base.task.AsyncTask;

class SerialExecutor
implements Executor {
    final ArrayDeque<Runnable> mTasks = new ArrayDeque();
    Runnable mActive;

    SerialExecutor() {
    }

    @Override
    public synchronized void execute(final Runnable r) {
        this.mTasks.offer(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    SerialExecutor.this.scheduleNext();
                }
            }
        });
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.mActive = this.mTasks.poll();
        if (this.mActive != null) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(this.mActive);
        }
    }
}

