/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.view.Choreographer;
import org.chromium.base.task.SingleThreadTaskRunner;

final class ChoreographerTaskRunner
implements SingleThreadTaskRunner {
    private final Choreographer mChoreographer;

    ChoreographerTaskRunner(Choreographer choreographer) {
        this.mChoreographer = choreographer;
    }

    @Override
    public boolean belongsToCurrentThread() {
        try {
            return this.mChoreographer == Choreographer.getInstance();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public void postTask(final Runnable task) {
        this.mChoreographer.postFrameCallback(new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                task.run();
            }
        });
    }

    @Override
    public void postDelayedTask(final Runnable task, long delayMillis) {
        this.mChoreographer.postFrameCallbackDelayed(new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                task.run();
            }
        }, delayMillis);
    }
}

