/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Process;
import java.util.HashMap;
import org.chromium.base.UserData;

public final class UserDataHost {
    private final long mThreadId = Process.myTid();
    private HashMap<Class<? extends UserData>, UserData> mUserDataMap = new HashMap();

    private static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("Neither key nor object of UserDataHost can be null.");
        }
    }

    private void checkThreadAndState() {
        if (this.mThreadId != (long)Process.myTid()) {
            throw new IllegalStateException("UserData must only be used on a single thread.");
        }
        if (this.mUserDataMap == null) {
            throw new IllegalStateException("Operation is not allowed after destroy().");
        }
    }

    public <T extends UserData> T setUserData(Class<T> key, T object) {
        this.checkThreadAndState();
        UserDataHost.checkArgument(key != null && object != null);
        this.mUserDataMap.put(key, object);
        return this.getUserData(key);
    }

    public <T extends UserData> T getUserData(Class<T> key) {
        this.checkThreadAndState();
        UserDataHost.checkArgument(key != null);
        return (T)((UserData)key.cast(this.mUserDataMap.get(key)));
    }

    public <T extends UserData> T removeUserData(Class<T> key) {
        this.checkThreadAndState();
        UserDataHost.checkArgument(key != null);
        if (!this.mUserDataMap.containsKey(key)) {
            throw new IllegalStateException("UserData for the key is not present.");
        }
        return (T)((UserData)key.cast(this.mUserDataMap.remove(key)));
    }

    public void destroy() {
        this.checkThreadAndState();
        HashMap<Class<? extends UserData>, UserData> map = this.mUserDataMap;
        this.mUserDataMap = null;
        for (UserData userData : map.values()) {
            userData.destroy();
        }
    }
}

