/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.net.NetworkChangeNotifier;
import org.chromium.net.impl.CronetEngineBuilderImpl;
import org.chromium.net.impl.CronetLibraryLoaderJni;
import org.chromium.net.impl.ImplVersion;
import org.chromium.net.impl.UserAgent;

@JNINamespace(value="cronet")
@VisibleForTesting
public class CronetLibraryLoader {
    private static final Object sLoadLock = new Object();
    private static final String LIBRARY_NAME = "cronet." + ImplVersion.getCronetVersion();
    private static final String TAG = CronetLibraryLoader.class.getSimpleName();
    private static final HandlerThread sInitThread = new HandlerThread("CronetInit");
    private static volatile boolean sLibraryLoaded = false;
    private static volatile boolean sInitThreadInitDone;
    private static final ConditionVariable sWaitForLibLoad;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInitialized(Context applicationContext, CronetEngineBuilderImpl builder) {
        Object object = sLoadLock;
        synchronized (object) {
            if (!sInitThreadInitDone) {
                ContextUtils.initApplicationContext(applicationContext);
                if (!sInitThread.isAlive()) {
                    sInitThread.start();
                }
                CronetLibraryLoader.postToInitThread(new Runnable(){

                    @Override
                    public void run() {
                        CronetLibraryLoader.ensureInitializedOnInitThread();
                    }
                });
            }
            if (!sLibraryLoaded) {
                if (builder.libraryLoader() != null) {
                    builder.libraryLoader().loadLibrary(LIBRARY_NAME);
                } else {
                    System.loadLibrary(LIBRARY_NAME);
                }
                String implVersion = ImplVersion.getCronetVersion();
                if (!implVersion.equals(CronetLibraryLoaderJni.get().getCronetVersion())) {
                    throw new RuntimeException(String.format("Expected Cronet version number %s, actual version number %s.", implVersion, CronetLibraryLoaderJni.get().getCronetVersion()));
                }
                Log.i(TAG, "Cronet version: %s, arch: %s", implVersion, System.getProperty("os.arch"));
                sLibraryLoaded = true;
                sWaitForLibLoad.open();
            }
        }
    }

    private static boolean onInitThread() {
        return sInitThread.getLooper() == Looper.myLooper();
    }

    static void ensureInitializedOnInitThread() {
        assert (CronetLibraryLoader.onInitThread());
        if (sInitThreadInitDone) {
            return;
        }
        NetworkChangeNotifier.init();
        NetworkChangeNotifier.registerToReceiveNotificationsAlways();
        sWaitForLibLoad.block();
        assert (sLibraryLoaded);
        CronetLibraryLoaderJni.get().cronetInitOnInitThread();
        sInitThreadInitDone = true;
    }

    public static void postToInitThread(Runnable r) {
        if (CronetLibraryLoader.onInitThread()) {
            r.run();
        } else {
            new Handler(sInitThread.getLooper()).post(r);
        }
    }

    @CalledByNative
    private static String getDefaultUserAgent() {
        return UserAgent.from((Context)ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void ensureInitializedFromNative() {
        Object object = sLoadLock;
        synchronized (object) {
            sLibraryLoaded = true;
            sWaitForLibLoad.open();
        }
        Context applicationContext = ContextUtils.getApplicationContext();
        assert (applicationContext != null);
        CronetLibraryLoader.ensureInitialized(applicationContext, null);
    }

    @CalledByNative
    private static void setNetworkThreadPriorityOnNetworkThread(int priority) {
        Process.setThreadPriority((int)priority);
    }

    static {
        sWaitForLibLoad = new ConditionVariable();
    }

    static interface Natives {
        public void cronetInitOnInitThread();

        public String getCronetVersion();
    }
}

