/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.CronetException;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.BidirectionalStreamNetworkException;
import org.chromium.net.impl.CallbackExceptionImpl;
import org.chromium.net.impl.CronetBidirectionalStreamJni;
import org.chromium.net.impl.CronetExceptionImpl;
import org.chromium.net.impl.CronetMetrics;
import org.chromium.net.impl.CronetUrlRequestContext;
import org.chromium.net.impl.Preconditions;
import org.chromium.net.impl.QuicExceptionImpl;
import org.chromium.net.impl.RequestFinishedInfoImpl;
import org.chromium.net.impl.UrlResponseInfoImpl;
import org.chromium.net.impl.VersionSafeCallbacks;

@JNINamespace(value="cronet")
@VisibleForTesting
public class CronetBidirectionalStream
extends ExperimentalBidirectionalStream {
    private final CronetUrlRequestContext mRequestContext;
    private final Executor mExecutor;
    private final VersionSafeCallbacks.BidirectionalStreamCallback mCallback;
    private final String mInitialUrl;
    private final int mInitialPriority;
    private final String mInitialMethod;
    private final String[] mRequestHeaders;
    private final boolean mDelayRequestHeadersUntilFirstFlush;
    private final Collection<Object> mRequestAnnotations;
    private final boolean mTrafficStatsTagSet;
    private final int mTrafficStatsTag;
    private final boolean mTrafficStatsUidSet;
    private final int mTrafficStatsUid;
    private final long mNetworkHandle;
    private CronetException mException;
    private final Object mNativeStreamLock = new Object();
    @GuardedBy(value="mNativeStreamLock")
    private LinkedList<ByteBuffer> mPendingData;
    @GuardedBy(value="mNativeStreamLock")
    private LinkedList<ByteBuffer> mFlushData;
    @GuardedBy(value="mNativeStreamLock")
    private boolean mEndOfStreamWritten;
    @GuardedBy(value="mNativeStreamLock")
    private boolean mRequestHeadersSent;
    @GuardedBy(value="mNativeStreamLock")
    private RequestFinishedInfo.Metrics mMetrics;
    @GuardedBy(value="mNativeStreamLock")
    private long mNativeStream;
    @GuardedBy(value="mNativeStreamLock")
    private int mReadState = 0;
    @GuardedBy(value="mNativeStreamLock")
    private int mWriteState = 0;
    private UrlResponseInfoImpl mResponseInfo;
    private OnReadCompletedRunnable mOnReadCompletedTask;
    private Runnable mOnDestroyedCallbackForTesting;

    CronetBidirectionalStream(CronetUrlRequestContext requestContext, String url, int priority, BidirectionalStream.Callback callback, Executor executor, String httpMethod, List<Map.Entry<String, String>> requestHeaders, boolean delayRequestHeadersUntilNextFlush, Collection<Object> requestAnnotations, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, long networkHandle) {
        this.mRequestContext = requestContext;
        this.mInitialUrl = url;
        this.mInitialPriority = CronetBidirectionalStream.convertStreamPriority(priority);
        this.mCallback = new VersionSafeCallbacks.BidirectionalStreamCallback(callback);
        this.mExecutor = executor;
        this.mInitialMethod = httpMethod;
        this.mRequestHeaders = CronetBidirectionalStream.stringsFromHeaderList(requestHeaders);
        this.mDelayRequestHeadersUntilFirstFlush = delayRequestHeadersUntilNextFlush;
        this.mPendingData = new LinkedList();
        this.mFlushData = new LinkedList();
        this.mRequestAnnotations = requestAnnotations;
        this.mTrafficStatsTagSet = trafficStatsTagSet;
        this.mTrafficStatsTag = trafficStatsTag;
        this.mTrafficStatsUidSet = trafficStatsUidSet;
        this.mTrafficStatsUid = trafficStatsUid;
        this.mNetworkHandle = networkHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.mReadState != 0) {
                throw new IllegalStateException("Stream is already started.");
            }
            try {
                this.mNativeStream = CronetBidirectionalStreamJni.get().createBidirectionalStream(this, this.mRequestContext.getUrlRequestContextAdapter(), !this.mDelayRequestHeadersUntilFirstFlush, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mNetworkHandle);
                this.mRequestContext.onRequestStarted();
                int startResult = CronetBidirectionalStreamJni.get().start(this.mNativeStream, this, this.mInitialUrl, this.mInitialPriority, this.mInitialMethod, this.mRequestHeaders, !CronetBidirectionalStream.doesMethodAllowWriteData(this.mInitialMethod));
                if (startResult == -1) {
                    throw new IllegalArgumentException("Invalid http method " + this.mInitialMethod);
                }
                if (startResult > 0) {
                    int headerPos = startResult - 1;
                    throw new IllegalArgumentException("Invalid header " + this.mRequestHeaders[headerPos] + "=" + this.mRequestHeaders[headerPos + 1]);
                }
                this.mWriteState = 1;
                this.mReadState = 1;
            }
            catch (RuntimeException e) {
                this.destroyNativeStreamLocked(false);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ByteBuffer buffer) {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            Preconditions.checkHasRemaining((ByteBuffer)buffer);
            Preconditions.checkDirect((ByteBuffer)buffer);
            if (this.mReadState != 2) {
                throw new IllegalStateException("Unexpected read attempt.");
            }
            if (this.isDoneLocked()) {
                return;
            }
            if (this.mOnReadCompletedTask == null) {
                this.mOnReadCompletedTask = new OnReadCompletedRunnable();
            }
            this.mReadState = 3;
            if (!CronetBidirectionalStreamJni.get().readData(this.mNativeStream, this, buffer, buffer.position(), buffer.limit())) {
                this.mReadState = 2;
                throw new IllegalArgumentException("Unable to call native read");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer buffer, boolean endOfStream) {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            Preconditions.checkDirect((ByteBuffer)buffer);
            if (!buffer.hasRemaining() && !endOfStream) {
                throw new IllegalArgumentException("Empty buffer before end of stream.");
            }
            if (this.mEndOfStreamWritten) {
                throw new IllegalArgumentException("Write after writing end of stream.");
            }
            if (this.isDoneLocked()) {
                return;
            }
            this.mPendingData.add(buffer);
            if (endOfStream) {
                this.mEndOfStreamWritten = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.isDoneLocked() || this.mWriteState != 8 && this.mWriteState != 9) {
                return;
            }
            if (this.mPendingData.isEmpty() && this.mFlushData.isEmpty()) {
                if (!this.mRequestHeadersSent) {
                    this.mRequestHeadersSent = true;
                    CronetBidirectionalStreamJni.get().sendRequestHeaders(this.mNativeStream, this);
                    if (!CronetBidirectionalStream.doesMethodAllowWriteData(this.mInitialMethod)) {
                        this.mWriteState = 10;
                    }
                }
                return;
            }
            assert (!this.mPendingData.isEmpty() || !this.mFlushData.isEmpty());
            if (!this.mPendingData.isEmpty()) {
                this.mFlushData.addAll(this.mPendingData);
                this.mPendingData.clear();
            }
            if (this.mWriteState == 9) {
                return;
            }
            this.sendFlushDataLocked();
        }
    }

    private void sendFlushDataLocked() {
        assert (this.mWriteState == 8);
        int size = this.mFlushData.size();
        ByteBuffer[] buffers = new ByteBuffer[size];
        int[] positions = new int[size];
        int[] limits = new int[size];
        for (int i = 0; i < size; ++i) {
            ByteBuffer buffer;
            buffers[i] = buffer = this.mFlushData.poll();
            positions[i] = buffer.position();
            limits[i] = buffer.limit();
        }
        assert (this.mFlushData.isEmpty());
        assert (buffers.length >= 1);
        this.mWriteState = 9;
        this.mRequestHeadersSent = true;
        if (!CronetBidirectionalStreamJni.get().writevData(this.mNativeStream, this, buffers, positions, limits, this.mEndOfStreamWritten && this.mPendingData.isEmpty())) {
            this.mWriteState = 8;
            throw new IllegalArgumentException("Unable to call native writev.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<ByteBuffer> getPendingDataForTesting() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            LinkedList<ByteBuffer> pendingData = new LinkedList<ByteBuffer>();
            for (ByteBuffer buffer : this.mPendingData) {
                pendingData.add(buffer.asReadOnlyBuffer());
            }
            return pendingData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<ByteBuffer> getFlushDataForTesting() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            LinkedList<ByteBuffer> flushData = new LinkedList<ByteBuffer>();
            for (ByteBuffer buffer : this.mFlushData) {
                flushData.add(buffer.asReadOnlyBuffer());
            }
            return flushData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.isDoneLocked() || this.mReadState == 0) {
                return;
            }
            this.mWriteState = 5;
            this.mReadState = 5;
            this.destroyNativeStreamLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            return this.isDoneLocked();
        }
    }

    @GuardedBy(value="mNativeStreamLock")
    private boolean isDoneLocked() {
        return this.mReadState != 0 && this.mNativeStream == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeOnSucceededOnExecutor() {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.isDoneLocked()) {
                return;
            }
            if (this.mWriteState != 10 || this.mReadState != 4) {
                return;
            }
            this.mWriteState = 7;
            this.mReadState = 7;
            this.destroyNativeStreamLocked(false);
        }
        try {
            this.mCallback.onSucceeded((BidirectionalStream)this, (UrlResponseInfo)this.mResponseInfo);
        }
        catch (Exception e) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onSucceeded method", e);
        }
    }

    @CalledByNative
    private void onStreamReady(final boolean requestHeadersSent) {
        this.postTaskToExecutor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetBidirectionalStream.this.mNativeStreamLock;
                synchronized (object) {
                    if (CronetBidirectionalStream.this.isDoneLocked()) {
                        return;
                    }
                    CronetBidirectionalStream.this.mRequestHeadersSent = requestHeadersSent;
                    CronetBidirectionalStream.this.mReadState = 2;
                    CronetBidirectionalStream.this.mWriteState = !CronetBidirectionalStream.doesMethodAllowWriteData(CronetBidirectionalStream.this.mInitialMethod) && CronetBidirectionalStream.this.mRequestHeadersSent ? 10 : 8;
                }
                try {
                    CronetBidirectionalStream.this.mCallback.onStreamReady((BidirectionalStream)CronetBidirectionalStream.this);
                }
                catch (Exception e) {
                    CronetBidirectionalStream.this.onCallbackException(e);
                }
            }
        });
    }

    @CalledByNative
    private void onResponseHeadersReceived(int httpStatusCode, String negotiatedProtocol, String[] headers, long receivedByteCount) {
        try {
            this.mResponseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, negotiatedProtocol, headers, receivedByteCount);
        }
        catch (Exception e) {
            this.failWithException((CronetException)new CronetExceptionImpl("Cannot prepare ResponseInfo", null));
            return;
        }
        this.postTaskToExecutor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetBidirectionalStream.this.mNativeStreamLock;
                synchronized (object) {
                    if (CronetBidirectionalStream.this.isDoneLocked()) {
                        return;
                    }
                    CronetBidirectionalStream.this.mReadState = 2;
                }
                try {
                    CronetBidirectionalStream.this.mCallback.onResponseHeadersReceived((BidirectionalStream)CronetBidirectionalStream.this, (UrlResponseInfo)CronetBidirectionalStream.this.mResponseInfo);
                }
                catch (Exception e) {
                    CronetBidirectionalStream.this.onCallbackException(e);
                }
            }
        });
    }

    @CalledByNative
    private void onReadCompleted(ByteBuffer byteBuffer, int bytesRead, int initialPosition, int initialLimit, long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        if (byteBuffer.position() != initialPosition || byteBuffer.limit() != initialLimit) {
            this.failWithException((CronetException)new CronetExceptionImpl("ByteBuffer modified externally during read", null));
            return;
        }
        if (bytesRead < 0 || initialPosition + bytesRead > initialLimit) {
            this.failWithException((CronetException)new CronetExceptionImpl("Invalid number of bytes read", null));
            return;
        }
        byteBuffer.position(initialPosition + bytesRead);
        assert (this.mOnReadCompletedTask.mByteBuffer == null);
        this.mOnReadCompletedTask.mByteBuffer = byteBuffer;
        this.mOnReadCompletedTask.mEndOfStream = bytesRead == 0;
        this.postTaskToExecutor(this.mOnReadCompletedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onWritevCompleted(ByteBuffer[] byteBuffers, int[] initialPositions, int[] initialLimits, boolean endOfStream) {
        assert (byteBuffers.length == initialPositions.length);
        assert (byteBuffers.length == initialLimits.length);
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.isDoneLocked()) {
                return;
            }
            this.mWriteState = 8;
            if (!this.mFlushData.isEmpty()) {
                this.sendFlushDataLocked();
            }
        }
        for (int i = 0; i < byteBuffers.length; ++i) {
            ByteBuffer buffer = byteBuffers[i];
            if (buffer.position() != initialPositions[i] || buffer.limit() != initialLimits[i]) {
                this.failWithException((CronetException)new CronetExceptionImpl("ByteBuffer modified externally during write", null));
                return;
            }
            buffer.position(buffer.limit());
            this.postTaskToExecutor(new OnWriteCompletedRunnable(buffer, endOfStream && i == byteBuffers.length - 1));
        }
    }

    @CalledByNative
    private void onResponseTrailersReceived(String[] trailers) {
        UrlResponseInfoImpl.HeaderBlockImpl trailersBlock = new UrlResponseInfoImpl.HeaderBlockImpl(CronetBidirectionalStream.headersListFromStrings(trailers));
        this.postTaskToExecutor(new Runnable((UrlResponseInfo.HeaderBlock)trailersBlock){
            final /* synthetic */ UrlResponseInfo.HeaderBlock val$trailersBlock;
            {
                this.val$trailersBlock = headerBlock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetBidirectionalStream.this.mNativeStreamLock;
                synchronized (object) {
                    if (CronetBidirectionalStream.this.isDoneLocked()) {
                        return;
                    }
                }
                try {
                    CronetBidirectionalStream.this.mCallback.onResponseTrailersReceived((BidirectionalStream)CronetBidirectionalStream.this, (UrlResponseInfo)CronetBidirectionalStream.this.mResponseInfo, this.val$trailersBlock);
                }
                catch (Exception e) {
                    CronetBidirectionalStream.this.onCallbackException(e);
                }
            }
        });
    }

    @CalledByNative
    private void onError(int errorCode, int nativeError, int nativeQuicError, String errorString, long receivedByteCount) {
        if (this.mResponseInfo != null) {
            this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        }
        if (errorCode == 10 || errorCode == 3) {
            this.failWithException((CronetException)new QuicExceptionImpl("Exception in BidirectionalStream: " + errorString, errorCode, nativeError, nativeQuicError));
        } else {
            this.failWithException((CronetException)new BidirectionalStreamNetworkException("Exception in BidirectionalStream: " + errorString, errorCode, nativeError));
        }
    }

    @CalledByNative
    private void onCanceled() {
        this.postTaskToExecutor(new Runnable(){

            @Override
            public void run() {
                try {
                    CronetBidirectionalStream.this.mCallback.onCanceled((BidirectionalStream)CronetBidirectionalStream.this, (UrlResponseInfo)CronetBidirectionalStream.this.mResponseInfo);
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onCanceled method", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onMetricsCollected(long requestStartMs, long dnsStartMs, long dnsEndMs, long connectStartMs, long connectEndMs, long sslStartMs, long sslEndMs, long sendingStartMs, long sendingEndMs, long pushStartMs, long pushEndMs, long responseStartMs, long requestEndMs, boolean socketReused, long sentByteCount, long receivedByteCount) {
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.mMetrics != null) {
                throw new IllegalStateException("Metrics collection should only happen once.");
            }
            this.mMetrics = new CronetMetrics(requestStartMs, dnsStartMs, dnsEndMs, connectStartMs, connectEndMs, sslStartMs, sslEndMs, sendingStartMs, sendingEndMs, pushStartMs, pushEndMs, responseStartMs, requestEndMs, socketReused, sentByteCount, receivedByteCount);
            assert (this.mReadState == this.mWriteState);
            assert (this.mReadState == 7 || this.mReadState == 6 || this.mReadState == 5);
            int finishedReason = this.mReadState == 7 ? 0 : (this.mReadState == 5 ? 2 : 1);
            RequestFinishedInfoImpl requestFinishedInfo = new RequestFinishedInfoImpl(this.mInitialUrl, this.mRequestAnnotations, this.mMetrics, finishedReason, (UrlResponseInfo)this.mResponseInfo, this.mException);
            this.mRequestContext.reportRequestFinished((RequestFinishedInfo)requestFinishedInfo);
        }
    }

    @VisibleForTesting
    public void setOnDestroyedCallbackForTesting(Runnable onDestroyedCallbackForTesting) {
        this.mOnDestroyedCallbackForTesting = onDestroyedCallbackForTesting;
    }

    private static boolean doesMethodAllowWriteData(String methodName) {
        return !methodName.equals("GET") && !methodName.equals("HEAD");
    }

    private static ArrayList<Map.Entry<String, String>> headersListFromStrings(String[] headers) {
        ArrayList<Map.Entry<String, String>> headersList = new ArrayList<Map.Entry<String, String>>(headers.length / 2);
        for (int i = 0; i < headers.length; i += 2) {
            headersList.add(new AbstractMap.SimpleImmutableEntry<String, String>(headers[i], headers[i + 1]));
        }
        return headersList;
    }

    private static String[] stringsFromHeaderList(List<Map.Entry<String, String>> headersList) {
        String[] headersArray = new String[headersList.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> requestHeader : headersList) {
            headersArray[i++] = requestHeader.getKey();
            headersArray[i++] = requestHeader.getValue();
        }
        return headersArray;
    }

    private static int convertStreamPriority(int priority) {
        switch (priority) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Invalid stream priority.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postTaskToExecutor(Runnable task) {
        try {
            this.mExecutor.execute(task);
        }
        catch (RejectedExecutionException failException) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", failException);
            Object object = this.mNativeStreamLock;
            synchronized (object) {
                this.mWriteState = 6;
                this.mReadState = 6;
                this.destroyNativeStreamLocked(false);
            }
        }
    }

    private UrlResponseInfoImpl prepareResponseInfoOnNetworkThread(int httpStatusCode, String negotiatedProtocol, String[] headers, long receivedByteCount) {
        UrlResponseInfoImpl responseInfo = new UrlResponseInfoImpl(Arrays.asList(this.mInitialUrl), httpStatusCode, "", CronetBidirectionalStream.headersListFromStrings(headers), false, negotiatedProtocol, null, receivedByteCount);
        return responseInfo;
    }

    @GuardedBy(value="mNativeStreamLock")
    private void destroyNativeStreamLocked(boolean sendOnCanceled) {
        Log.i(CronetUrlRequestContext.LOG_TAG, "destroyNativeStreamLocked " + ((Object)((Object)this)).toString(), new Object[0]);
        if (this.mNativeStream == 0L) {
            return;
        }
        CronetBidirectionalStreamJni.get().destroy(this.mNativeStream, this, sendOnCanceled);
        this.mRequestContext.onRequestDestroyed();
        this.mNativeStream = 0L;
        if (this.mOnDestroyedCallbackForTesting != null) {
            this.mOnDestroyedCallbackForTesting.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failWithExceptionOnExecutor(CronetException e) {
        this.mException = e;
        Object object = this.mNativeStreamLock;
        synchronized (object) {
            if (this.isDoneLocked()) {
                return;
            }
            this.mWriteState = 6;
            this.mReadState = 6;
            this.destroyNativeStreamLocked(false);
        }
        try {
            this.mCallback.onFailed((BidirectionalStream)this, (UrlResponseInfo)this.mResponseInfo, e);
        }
        catch (Exception failException) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception notifying of failed request", failException);
        }
    }

    private void onCallbackException(Exception e) {
        CallbackExceptionImpl streamError = new CallbackExceptionImpl("CalledByNative method has thrown an exception", (Throwable)e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in CalledByNative method", e);
        this.failWithExceptionOnExecutor((CronetException)streamError);
    }

    private void failWithException(final CronetException exception) {
        this.postTaskToExecutor(new Runnable(){

            @Override
            public void run() {
                CronetBidirectionalStream.this.failWithExceptionOnExecutor(exception);
            }
        });
    }

    static interface Natives {
        public long createBidirectionalStream(CronetBidirectionalStream var1, long var2, boolean var4, boolean var5, int var6, boolean var7, int var8, long var9);

        @NativeClassQualifiedName(value="CronetBidirectionalStreamAdapter")
        public int start(long var1, CronetBidirectionalStream var3, String var4, int var5, String var6, String[] var7, boolean var8);

        @NativeClassQualifiedName(value="CronetBidirectionalStreamAdapter")
        public void sendRequestHeaders(long var1, CronetBidirectionalStream var3);

        @NativeClassQualifiedName(value="CronetBidirectionalStreamAdapter")
        public boolean readData(long var1, CronetBidirectionalStream var3, ByteBuffer var4, int var5, int var6);

        @NativeClassQualifiedName(value="CronetBidirectionalStreamAdapter")
        public boolean writevData(long var1, CronetBidirectionalStream var3, ByteBuffer[] var4, int[] var5, int[] var6, boolean var7);

        @NativeClassQualifiedName(value="CronetBidirectionalStreamAdapter")
        public void destroy(long var1, CronetBidirectionalStream var3, boolean var4);
    }

    private final class OnWriteCompletedRunnable
    implements Runnable {
        private ByteBuffer mByteBuffer;
        private final boolean mEndOfStream;

        OnWriteCompletedRunnable(ByteBuffer buffer, boolean endOfStream) {
            this.mByteBuffer = buffer;
            this.mEndOfStream = endOfStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ByteBuffer buffer = this.mByteBuffer;
                this.mByteBuffer = null;
                boolean maybeOnSucceeded = false;
                Object object = CronetBidirectionalStream.this.mNativeStreamLock;
                synchronized (object) {
                    if (CronetBidirectionalStream.this.isDoneLocked()) {
                        return;
                    }
                    if (this.mEndOfStream) {
                        CronetBidirectionalStream.this.mWriteState = 10;
                        maybeOnSucceeded = CronetBidirectionalStream.this.mReadState == 4;
                    }
                }
                CronetBidirectionalStream.this.mCallback.onWriteCompleted((BidirectionalStream)CronetBidirectionalStream.this, (UrlResponseInfo)CronetBidirectionalStream.this.mResponseInfo, buffer, this.mEndOfStream);
                if (maybeOnSucceeded) {
                    CronetBidirectionalStream.this.maybeOnSucceededOnExecutor();
                }
            }
            catch (Exception e) {
                CronetBidirectionalStream.this.onCallbackException(e);
            }
        }
    }

    private final class OnReadCompletedRunnable
    implements Runnable {
        ByteBuffer mByteBuffer;
        boolean mEndOfStream;

        private OnReadCompletedRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ByteBuffer buffer = this.mByteBuffer;
                this.mByteBuffer = null;
                boolean maybeOnSucceeded = false;
                Object object = CronetBidirectionalStream.this.mNativeStreamLock;
                synchronized (object) {
                    if (CronetBidirectionalStream.this.isDoneLocked()) {
                        return;
                    }
                    if (this.mEndOfStream) {
                        CronetBidirectionalStream.this.mReadState = 4;
                        maybeOnSucceeded = CronetBidirectionalStream.this.mWriteState == 10;
                    } else {
                        CronetBidirectionalStream.this.mReadState = 2;
                    }
                }
                CronetBidirectionalStream.this.mCallback.onReadCompleted((BidirectionalStream)CronetBidirectionalStream.this, (UrlResponseInfo)CronetBidirectionalStream.this.mResponseInfo, buffer, this.mEndOfStream);
                if (maybeOnSucceeded) {
                    CronetBidirectionalStream.this.maybeOnSucceededOnExecutor();
                }
            }
            catch (Exception e) {
                CronetBidirectionalStream.this.onCallbackException(e);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface State {
        public static final int NOT_STARTED = 0;
        public static final int STARTED = 1;
        public static final int WAITING_FOR_READ = 2;
        public static final int READING = 3;
        public static final int READING_DONE = 4;
        public static final int CANCELED = 5;
        public static final int ERROR = 6;
        public static final int SUCCESS = 7;
        public static final int WAITING_FOR_FLUSH = 8;
        public static final int WRITING = 9;
        public static final int WRITING_DONE = 10;
    }
}

