/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.supplier;

import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import org.chromium.base.Callback;
import org.chromium.base.supplier.ObservableSupplier;

public class OneShotCallback<E> {
    private final Callback<E> mCallbackWrapper = new CallbackWrapper();
    private final WeakReference<ObservableSupplier<E>> mWeakSupplier;
    private final Callback<E> mCallback;

    public OneShotCallback(@NonNull ObservableSupplier<E> supplier, @NonNull Callback<E> callback) {
        this.mWeakSupplier = new WeakReference<ObservableSupplier<E>>(supplier);
        this.mCallback = callback;
        supplier.addObserver(this.mCallbackWrapper);
    }

    private class CallbackWrapper
    implements Callback<E> {
        private CallbackWrapper() {
        }

        @Override
        public void onResult(E result) {
            OneShotCallback.this.mCallback.onResult(result);
            ObservableSupplier supplier = (ObservableSupplier)OneShotCallback.this.mWeakSupplier.get();
            assert (supplier != null) : "This can only be called by supplier, which should not be null.";
            supplier.removeObserver(OneShotCallback.this.mCallbackWrapper);
        }
    }
}

