/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import org.chromium.base.metrics.CachingUmaRecorder;
import org.chromium.base.metrics.NativeUmaRecorder;
import org.chromium.base.metrics.UmaRecorder;

public class UmaRecorderHolder {
    private static CachingUmaRecorder sRecorder = new CachingUmaRecorder();
    private static boolean sSetUpNativeUmaRecorder = true;
    private static boolean sNativeInitialized;

    private UmaRecorderHolder() {
    }

    public static UmaRecorder get() {
        return sRecorder;
    }

    public static void setNonNativeDelegate(UmaRecorder recorder) {
        UmaRecorder previous = sRecorder.setDelegate(recorder);
        assert (!(previous instanceof NativeUmaRecorder)) : "A NativeUmaRecorder has already been set";
    }

    public static void setUpNativeUmaRecorder(boolean setUpNativeUmaRecorder) {
        sSetUpNativeUmaRecorder = setUpNativeUmaRecorder;
    }

    public static void onLibraryLoaded() {
        if (!sSetUpNativeUmaRecorder) {
            return;
        }
        assert (!sNativeInitialized);
        sNativeInitialized = true;
        sRecorder.setDelegate(new NativeUmaRecorder());
    }

    public static void resetForTesting() {
        if (!sNativeInitialized) {
            sRecorder = new CachingUmaRecorder();
        }
    }
}

