/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.os.Process;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import androidx.annotation.RequiresApi;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ContextUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.base.compat.ApiHelperForP;

@JNINamespace(value="base::android")
public class RadioUtils {
    private static Boolean sHaveAccessNetworkState;
    private static Boolean sHaveAccessWifiState;

    private RadioUtils() {
    }

    @CalledByNative
    private static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 28 && RadioUtils.haveAccessNetworkState() && RadioUtils.haveAccessWifiState();
    }

    private static boolean haveAccessNetworkState() {
        if (sHaveAccessNetworkState == null) {
            sHaveAccessNetworkState = ApiCompatibilityUtils.checkPermission(ContextUtils.getApplicationContext(), "android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid()) == 0;
        }
        return sHaveAccessNetworkState;
    }

    private static boolean haveAccessWifiState() {
        if (sHaveAccessWifiState == null) {
            sHaveAccessWifiState = ApiCompatibilityUtils.checkPermission(ContextUtils.getApplicationContext(), "android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid()) == 0;
        }
        return sHaveAccessWifiState;
    }

    @CalledByNative
    @RequiresApi(value=28)
    private static boolean isWifiConnected() {
        assert (RadioUtils.isSupported());
        try (TraceEvent te = TraceEvent.scoped("RadioUtils::isWifiConnected");){
            ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
            Network network = ApiHelperForM.getActiveNetwork(connectivityManager);
            if (network == null) {
                boolean bl = false;
                return bl;
            }
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
            if (networkCapabilities == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = networkCapabilities.hasTransport(1);
            return bl;
        }
    }

    @CalledByNative
    @RequiresApi(value=28)
    private static int getCellSignalLevel() {
        assert (RadioUtils.isSupported());
        try (TraceEvent te = TraceEvent.scoped("RadioUtils::getCellSignalLevel");){
            TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
            int level = -1;
            try {
                SignalStrength signalStrength = ApiHelperForP.getSignalStrength(telephonyManager);
                if (signalStrength != null) {
                    level = signalStrength.getLevel();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            int n = level;
            return n;
        }
    }

    @CalledByNative
    @RequiresApi(value=28)
    private static int getCellDataActivity() {
        assert (RadioUtils.isSupported());
        try (TraceEvent te = TraceEvent.scoped("RadioUtils::getCellDataActivity");){
            TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
            try {
                int n = telephonyManager.getDataActivity();
                return n;
            }
            catch (SecurityException e) {
                int n = -1;
                if (te != null) {
                    te.close();
                }
                return n;
            }
        }
    }
}

