/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedList;
import java.util.List;
import org.chromium.base.Callback;
import org.chromium.base.Function;

public class Promise<T> {
    private int mState = 0;
    private T mResult;
    private final List<Callback<T>> mFulfillCallbacks = new LinkedList<Callback<T>>();
    private Exception mRejectReason;
    private final List<Callback<Exception>> mRejectCallbacks = new LinkedList<Callback<Exception>>();
    private final Thread mThread = Thread.currentThread();
    private final Handler mHandler = new Handler();
    private boolean mThrowingRejectionHandler;

    public void then(Callback<T> onFulfill) {
        this.checkThread();
        if (this.mThrowingRejectionHandler) {
            this.thenInner(onFulfill);
            return;
        }
        assert (this.mRejectCallbacks.size() == 0) : "Do not call the single argument Promise.then(Callback) on a Promise that already has a rejection handler.";
        Callback<Exception> onReject = reason -> {
            throw new UnhandledRejectionException("Promise was rejected without a rejection handler.", (Throwable)reason);
        };
        this.then(onFulfill, onReject);
        this.mThrowingRejectionHandler = true;
    }

    public void then(Callback<T> onFulfill, Callback<Exception> onReject) {
        this.checkThread();
        this.thenInner(onFulfill);
        this.exceptInner(onReject);
    }

    public void except(Callback<Exception> onReject) {
        this.checkThread();
        this.exceptInner(onReject);
    }

    private void thenInner(Callback<T> onFulfill) {
        if (this.mState == 1) {
            this.postCallbackToLooper(onFulfill, this.mResult);
        } else if (this.mState == 0) {
            this.mFulfillCallbacks.add(onFulfill);
        }
    }

    private void exceptInner(Callback<Exception> onReject) {
        assert (!this.mThrowingRejectionHandler) : "Do not add an exception handler to a Promise you have called the single argument Promise.then(Callback) on.";
        if (this.mState == 2) {
            this.postCallbackToLooper(onReject, this.mRejectReason);
        } else if (this.mState == 0) {
            this.mRejectCallbacks.add(onReject);
        }
    }

    public <RT> Promise<RT> then(Function<T, RT> function) {
        this.checkThread();
        Promise promise = new Promise();
        this.thenInner(result -> {
            try {
                promise.fulfill(function.apply(result));
            }
            catch (Exception e) {
                promise.reject(e);
            }
        });
        this.exceptInner(promise::reject);
        return promise;
    }

    public <RT> Promise<RT> then(AsyncFunction<T, RT> function) {
        this.checkThread();
        Promise promise = new Promise();
        this.thenInner(result -> {
            try {
                ((Promise)function.apply(result)).then(promise::fulfill, promise::reject);
            }
            catch (Exception e) {
                promise.reject(e);
            }
        });
        this.exceptInner(promise::reject);
        return promise;
    }

    public void fulfill(T result) {
        this.checkThread();
        assert (this.mState == 0);
        this.mState = 1;
        this.mResult = result;
        for (Callback<T> callback : this.mFulfillCallbacks) {
            this.postCallbackToLooper(callback, result);
        }
        this.mFulfillCallbacks.clear();
    }

    public void reject(Exception reason) {
        this.checkThread();
        assert (this.mState == 0);
        this.mState = 2;
        this.mRejectReason = reason;
        for (Callback<Exception> callback : this.mRejectCallbacks) {
            this.postCallbackToLooper(callback, reason);
        }
        this.mRejectCallbacks.clear();
    }

    public void reject() {
        this.reject(null);
    }

    public boolean isFulfilled() {
        this.checkThread();
        return this.mState == 1;
    }

    public boolean isRejected() {
        this.checkThread();
        return this.mState == 2;
    }

    public T getResult() {
        assert (this.isFulfilled());
        return this.mResult;
    }

    public static <T> Promise<T> fulfilled(T result) {
        Promise<T> promise = new Promise<T>();
        promise.fulfill(result);
        return promise;
    }

    public static <T> Promise<T> rejected() {
        Promise<T> promise = new Promise<T>();
        promise.reject();
        return promise;
    }

    private void checkThread() {
        assert (this.mThread == Thread.currentThread()) : "Promise must only be used on a single Thread.";
    }

    private <S> void postCallbackToLooper(Callback<S> callback, S result) {
        this.mHandler.post(callback.bind(result));
    }

    public static class UnhandledRejectionException
    extends RuntimeException {
        public UnhandledRejectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface AsyncFunction<A, RT>
    extends Function<A, Promise<RT>> {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PromiseState {
        public static final int UNFULFILLED = 0;
        public static final int FULFILLED = 1;
        public static final int REJECTED = 2;
    }
}

