/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.Log;

public class PackageUtils {
    private static final String TAG = "PackageUtils";
    private static final char[] HEX_CHAR_LOOKUP = "0123456789ABCDEF".toCharArray();

    public static int getPackageVersion(Context context, String packageName) {
        int versionCode = -1;
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 0);
            if (packageInfo != null) {
                versionCode = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return versionCode;
    }

    public static boolean isPackageInstalled(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return true;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static List<String> getCertificateSHA256FingerprintForPackage(PackageManager pm, String packageName) {
        PackageInfo packageInfo;
        try {
            packageInfo = pm.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        if (packageInfo == null) {
            return null;
        }
        ArrayList<String> fingerprints = new ArrayList<String>(packageInfo.signatures.length);
        for (Signature signature : packageInfo.signatures) {
            ByteArrayInputStream input = new ByteArrayInputStream(signature.toByteArray());
            String hexString = null;
            try {
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(input);
                hexString = PackageUtils.byteArrayToHexString(MessageDigest.getInstance("SHA256").digest(certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                Log.w(TAG, "Certificate type X509 encoding failed", new Object[0]);
                return null;
            }
            catch (NoSuchAlgorithmException | CertificateException generalSecurityException) {
                // empty catch block
            }
            fingerprints.add(hexString);
        }
        return fingerprints;
    }

    static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(byteArray.length * 3 - 1);
        for (int i = 0; i < byteArray.length; ++i) {
            hexString.append(HEX_CHAR_LOOKUP[(byteArray[i] & 0xF0) >>> 4]);
            hexString.append(HEX_CHAR_LOOKUP[byteArray[i] & 0xF]);
            if (i >= byteArray.length - 1) continue;
            hexString.append(':');
        }
        return hexString.toString();
    }

    private PackageUtils() {
    }
}

