/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import androidx.annotation.UiThread;
import org.chromium.base.JavaExceptionReporterJni;
import org.chromium.base.PiiElider;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class JavaExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler mParent;
    private final boolean mCrashAfterReport;
    private boolean mHandlingException;

    private JavaExceptionReporter(Thread.UncaughtExceptionHandler parent, boolean crashAfterReport) {
        this.mParent = parent;
        this.mCrashAfterReport = crashAfterReport;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!this.mHandlingException) {
            this.mHandlingException = true;
            JavaExceptionReporterJni.get().reportJavaException(this.mCrashAfterReport, e);
        }
        if (this.mParent != null) {
            this.mParent.uncaughtException(t, e);
        }
    }

    @UiThread
    public static void reportStackTrace(String stackTrace) {
        assert (ThreadUtils.runningOnUiThread());
        JavaExceptionReporterJni.get().reportJavaStackTrace(PiiElider.sanitizeStacktrace(stackTrace));
    }

    @UiThread
    public static void reportException(Throwable exception) {
        assert (ThreadUtils.runningOnUiThread());
        JavaExceptionReporterJni.get().reportJavaException(false, exception);
    }

    @CalledByNative
    private static void installHandler(boolean crashAfterReport) {
        Thread.setDefaultUncaughtExceptionHandler(new JavaExceptionReporter(Thread.getDefaultUncaughtExceptionHandler(), crashAfterReport));
    }

    static interface Natives {
        public void reportJavaException(boolean var1, Throwable var2);

        public void reportJavaStackTrace(String var1);
    }
}

