/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.util.Pair;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.chromium.base.Callback;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> newHashMap(Pair<? extends K, ? extends V> ... entries) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Pair<? extends K, ? extends V> entry : entries) {
            map.put(entry.first, entry.second);
        }
        return map;
    }

    public static boolean[] booleanListToBooleanArray(@NonNull List<Boolean> list) {
        boolean[] array2 = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }

    public static int[] integerListToIntArray(@NonNull List<Integer> list) {
        int[] array2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }

    public static long[] longListToLongArray(@NonNull List<Long> list) {
        long[] array2 = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }

    public static <T> void forEach(Collection<? extends T> collection, Callback<T> worker) {
        for (T entry : collection) {
            worker.onResult(entry);
        }
    }

    public static <K, V> void forEach(Map<? extends K, ? extends V> map, Callback<Map.Entry<K, V>> worker) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            worker.onResult(entry);
        }
    }

    public static <T> List<T> strengthen(Collection<WeakReference<T>> weakRefs) {
        ArrayList ret = new ArrayList(weakRefs.size());
        Iterator<WeakReference<T>> it = weakRefs.iterator();
        while (it.hasNext()) {
            WeakReference<T> weakRef = it.next();
            Object strongRef = weakRef.get();
            if (strongRef == null) {
                it.remove();
                continue;
            }
            ret.add(strongRef);
        }
        return ret;
    }
}

