/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Callback;
import org.chromium.base.CollectionUtil;

public final class CallbackController {
    @Nullable
    @GuardedBy(value="mReentrantLock")
    private ArrayList<WeakReference<Cancelable>> mCancelables = new ArrayList();
    private final ReentrantLock mReentrantLock = new ReentrantLock(true);

    public <T> Callback<T> makeCancelable(@NonNull Callback<T> callback) {
        try (AutoCloseableLock acl = AutoCloseableLock.lock(this.mReentrantLock);){
            this.checkNotCanceled();
            CancelableCallback<T> cancelable = new CancelableCallback<T>(callback);
            this.mCancelables.add(new WeakReference<CancelableCallback<T>>(cancelable));
            CancelableCallback<T> cancelableCallback = cancelable;
            return cancelableCallback;
        }
    }

    public Runnable makeCancelable(@NonNull Runnable runnable) {
        try (AutoCloseableLock acl = AutoCloseableLock.lock(this.mReentrantLock);){
            this.checkNotCanceled();
            CancelableRunnable cancelable = new CancelableRunnable(runnable);
            this.mCancelables.add(new WeakReference<CancelableRunnable>(cancelable));
            CancelableRunnable cancelableRunnable = cancelable;
            return cancelableRunnable;
        }
    }

    public void destroy() {
        assert (!this.mReentrantLock.isHeldByCurrentThread());
        try (AutoCloseableLock acl = AutoCloseableLock.lock(this.mReentrantLock);){
            this.checkNotCanceled();
            for (Cancelable cancelable : CollectionUtil.strengthen(this.mCancelables)) {
                cancelable.cancel();
            }
            this.mCancelables = null;
        }
    }

    @GuardedBy(value="mReentrantLock")
    private void checkNotCanceled() {
        if (this.mCancelables == null) {
            throw new IllegalStateException("This CallbackController has already been destroyed.");
        }
    }

    private static class AutoCloseableLock
    implements AutoCloseable {
        private final Lock mLock;
        private boolean mIsLocked;

        private AutoCloseableLock(Lock lock, boolean isLocked) {
            this.mLock = lock;
            this.mIsLocked = isLocked;
        }

        static AutoCloseableLock lock(Lock l) {
            l.lock();
            return new AutoCloseableLock(l, true);
        }

        @Override
        public void close() {
            if (!this.mIsLocked) {
                throw new IllegalStateException("mLock isn't locked.");
            }
            this.mIsLocked = false;
            this.mLock.unlock();
        }
    }

    private class CancelableRunnable
    implements Cancelable,
    Runnable {
        @GuardedBy(value="mReentrantLock")
        private Runnable mRunnable;

        private CancelableRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void cancel() {
            this.mRunnable = null;
        }

        @Override
        public void run() {
            try (AutoCloseableLock acl = AutoCloseableLock.lock(CallbackController.this.mReentrantLock);){
                if (this.mRunnable != null) {
                    this.mRunnable.run();
                }
            }
        }
    }

    private class CancelableCallback<T>
    implements Cancelable,
    Callback<T> {
        @GuardedBy(value="mReentrantLock")
        private Callback<T> mCallback;

        private CancelableCallback(Callback<T> callback) {
            this.mCallback = callback;
        }

        @Override
        public void cancel() {
            this.mCallback = null;
        }

        @Override
        public void onResult(T result) {
            try (AutoCloseableLock acl = AutoCloseableLock.lock(CallbackController.this.mReentrantLock);){
                if (this.mCallback != null) {
                    this.mCallback.onResult(result);
                }
            }
        }
    }

    private static interface Cancelable {
        public void cancel();
    }
}

