/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.OptIn;
import androidx.core.os.BuildCompat;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.compat.ApiHelperForP;
import org.chromium.build.BuildConfig;

public class BuildInfo {
    private static final String TAG = "BuildInfo";
    private static final int MAX_FINGERPRINT_LENGTH = 128;
    private static PackageInfo sBrowserPackageInfo;
    private static ApplicationInfo sBrowserApplicationInfo;
    private static boolean sInitialized;
    private static String sFirebaseAppId;
    public final String hostPackageLabel;
    public final long hostVersionCode;
    public final String packageName;
    public final long versionCode;
    public final String versionName;
    public final String installerPackageName;
    public final String gmsVersionCode;
    public final String abiString;
    public final String androidBuildFingerprint;
    public final String customThemes;
    public final String resourcesVersion;
    public final boolean isTV;

    @CalledByNative
    private static String[] getAll() {
        BuildInfo buildInfo = BuildInfo.getInstance();
        String hostPackageName = ContextUtils.getApplicationContext().getPackageName();
        return new String[]{Build.BRAND, Build.DEVICE, Build.ID, Build.MANUFACTURER, Build.MODEL, String.valueOf(Build.VERSION.SDK_INT), Build.TYPE, Build.BOARD, hostPackageName, String.valueOf(buildInfo.hostVersionCode), buildInfo.hostPackageLabel, buildInfo.packageName, String.valueOf(buildInfo.versionCode), buildInfo.versionName, buildInfo.androidBuildFingerprint, buildInfo.gmsVersionCode, buildInfo.installerPackageName, buildInfo.abiString, sFirebaseAppId, buildInfo.customThemes, buildInfo.resourcesVersion, String.valueOf(ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion), BuildInfo.isDebugAndroid() ? "1" : "0", buildInfo.isTV ? "1" : "0", Build.VERSION.INCREMENTAL, Build.HARDWARE, BuildInfo.isAtLeastT() ? "1" : "0"};
    }

    private static String nullToEmpty(CharSequence seq) {
        return seq == null ? "" : seq.toString();
    }

    public static long packageVersionCode(PackageInfo pi) {
        if (Build.VERSION.SDK_INT >= 28) {
            return ApiHelperForP.getLongVersionCode(pi);
        }
        return pi.versionCode;
    }

    public static void setBrowserPackageInfo(PackageInfo packageInfo) {
        assert (!sInitialized);
        sBrowserPackageInfo = packageInfo;
    }

    public ApplicationInfo getBrowserApplicationInfo() {
        return sBrowserApplicationInfo;
    }

    public static BuildInfo getInstance() {
        return Holder.sInstance;
    }

    private BuildInfo() {
        sInitialized = true;
        try {
            Context appContext = ContextUtils.getApplicationContext();
            String hostPackageName = appContext.getPackageName();
            PackageManager pm = appContext.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(hostPackageName, 0);
            this.hostVersionCode = BuildInfo.packageVersionCode(pi);
            if (sBrowserPackageInfo != null) {
                this.packageName = BuildInfo.sBrowserPackageInfo.packageName;
                this.versionCode = BuildInfo.packageVersionCode(sBrowserPackageInfo);
                this.versionName = BuildInfo.nullToEmpty(BuildInfo.sBrowserPackageInfo.versionName);
                sBrowserApplicationInfo = BuildInfo.sBrowserPackageInfo.applicationInfo;
                sBrowserPackageInfo = null;
            } else {
                this.packageName = hostPackageName;
                this.versionCode = this.hostVersionCode;
                this.versionName = BuildInfo.nullToEmpty(pi.versionName);
                sBrowserApplicationInfo = appContext.getApplicationInfo();
            }
            this.hostPackageLabel = BuildInfo.nullToEmpty(pm.getApplicationLabel(pi.applicationInfo));
            this.installerPackageName = BuildInfo.nullToEmpty(pm.getInstallerPackageName(this.packageName));
            PackageInfo gmsPackageInfo = null;
            try {
                gmsPackageInfo = pm.getPackageInfo("com.google.android.gms", 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            this.gmsVersionCode = gmsPackageInfo != null ? String.valueOf(BuildInfo.packageVersionCode(gmsPackageInfo)) : "gms versionCode not available.";
            String hasCustomThemes = "true";
            try {
                pm.getPackageInfo("projekt.substratum", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                hasCustomThemes = "false";
            }
            this.customThemes = hasCustomThemes;
            String currentResourcesVersion = "Not Enabled";
            if (BuildConfig.R_STRING_PRODUCT_VERSION != 0) {
                try {
                    currentResourcesVersion = ContextUtils.getApplicationContext().getString(BuildConfig.R_STRING_PRODUCT_VERSION);
                }
                catch (Exception e) {
                    currentResourcesVersion = "Not found";
                }
            }
            this.resourcesVersion = currentResourcesVersion;
            this.abiString = Build.VERSION.SDK_INT >= 21 ? TextUtils.join((CharSequence)", ", (Object[])Build.SUPPORTED_ABIS) : String.format("ABI1: %s, ABI2: %s", Build.CPU_ABI, Build.CPU_ABI2);
            this.androidBuildFingerprint = Build.FINGERPRINT.substring(0, Math.min(Build.FINGERPRINT.length(), 128));
            UiModeManager uiModeManager = (UiModeManager)appContext.getSystemService("uimode");
            this.isTV = uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDebugAndroid() {
        return "eng".equals(Build.TYPE) || "userdebug".equals(Build.TYPE);
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static boolean isAtLeastT() {
        return BuildCompat.isAtLeastT();
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static boolean targetsAtLeastT() {
        int target = ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion;
        return target >= 33;
    }

    public static void setFirebaseAppId(String id2) {
        assert (sFirebaseAppId.equals(""));
        sFirebaseAppId = id2;
    }

    public static String getFirebaseAppId() {
        return sFirebaseAppId;
    }

    static {
        sFirebaseAppId = "";
    }

    private static class Holder {
        private static BuildInfo sInstance = new BuildInfo();

        private Holder() {
        }
    }
}

