/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.os.UserManager;
import android.provider.MediaStore;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textclassifier.TextClassifier;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.widget.ImageViewCompat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.ContextUtils;

public class ApiCompatibilityUtils {
    private ApiCompatibilityUtils() {
    }

    public static int compareLong(long lhs, long rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    public static int compareBoolean(boolean lhs, boolean rhs) {
        return lhs == rhs ? 0 : (lhs ? 1 : -1);
    }

    @NonNull
    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    @NonNull
    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static byte[] getBytesUtf8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toHtml(Spanned spanned, int option) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ApisN.toHtml(spanned, option);
        }
        return Html.toHtml((Spanned)spanned);
    }

    public static Intent getNotificationSettingsIntent() {
        Intent intent = new Intent();
        String packageName = ContextUtils.getApplicationContext().getPackageName();
        if (Build.VERSION.SDK_INT >= 26) {
            ApisO.initNotificationSettingsIntent(intent, packageName);
        } else {
            intent.setAction("android.settings.ACTION_APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", packageName);
            intent.putExtra("app_uid", ContextUtils.getApplicationContext().getApplicationInfo().uid);
        }
        return intent;
    }

    public static void setStatusBarColor(Window window, int statusBarColor) {
        if (Build.VERSION.SDK_INT < 26 && statusBarColor == -16777216 && window.getNavigationBarColor() == -16777216) {
            window.clearFlags(Integer.MIN_VALUE);
        } else {
            window.addFlags(Integer.MIN_VALUE);
        }
        window.setStatusBarColor(statusBarColor);
    }

    public static void setStatusBarIconColor(View rootView, boolean useDarkIcons) {
        if (Build.VERSION.SDK_INT >= 23) {
            ApisM.setStatusBarIconColor(rootView, useDarkIcons);
        }
    }

    public static Drawable getDrawable(Resources res, int id2) throws Resources.NotFoundException {
        return ApiCompatibilityUtils.getDrawableForDensity(res, id2, 0);
    }

    public static void setImageTintList(ImageView view, @Nullable ColorStateList tintList) {
        if (Build.VERSION.SDK_INT == 21 && tintList != null && view.getImageTintMode() == null) {
            view.setImageTintMode(PorterDuff.Mode.SRC_IN);
        }
        ImageViewCompat.setImageTintList((ImageView)view, (ColorStateList)tintList);
        if (Build.VERSION.SDK_INT == 21 && tintList == null) {
            view.refreshDrawableState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawableForDensity(Resources res, int id2, int density) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (density == 0) {
                Drawable drawable2 = res.getDrawable(id2, null);
                return drawable2;
            }
            Drawable drawable3 = res.getDrawableForDensity(id2, density, null);
            return drawable3;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    public static int getColor(Resources res, int id2) throws Resources.NotFoundException {
        return res.getColor(id2);
    }

    public static void setTextAppearance(TextView view, int id2) {
        view.setTextAppearance(view.getContext(), id2);
    }

    public static boolean isDemoUser() {
        return Build.VERSION.SDK_INT >= 25 && ApisN.isDemoUser();
    }

    public static int checkPermission(Context context, String permission, int pid, int uid) {
        try {
            return context.checkPermission(permission, pid, uid);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public static String getLocale(InputMethodSubtype inputMethodSubType) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ApisN.getLocale(inputMethodSubType);
        }
        return inputMethodSubType.getLocale();
    }

    public static boolean isInMultiWindowMode(Activity activity) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ApisN.isInMultiWindowMode(activity);
        }
        return false;
    }

    @NonNull
    public static List<Integer> getTargetableDisplayIds(Activity activity) {
        if (Build.VERSION.SDK_INT >= 29) {
            return ApisQ.getTargetableDisplayIds(activity);
        }
        return new ArrayList<Integer>();
    }

    public static void disableSmartSelectionTextClassifier(TextView textView) {
        if (Build.VERSION.SDK_INT >= 26) {
            ApisO.disableSmartSelectionTextClassifier(textView);
        }
    }

    public static Bundle createLaunchDisplayIdActivityOptions(int displayId) {
        if (Build.VERSION.SDK_INT >= 26) {
            return ApisO.createLaunchDisplayIdActivityOptions(displayId);
        }
        return null;
    }

    public static void setAccessibilityTraversalBefore(View view, int viewFocusedAfter) {
        if (Build.VERSION.SDK_INT >= 22) {
            ApisLmr1.setAccessibilityTraversalBefore(view, viewFocusedAfter);
        }
    }

    public static void setPasswordEditTextContentDescription(EditText view) {
        if (Build.VERSION.SDK_INT >= 24) {
            return;
        }
        if (ApiCompatibilityUtils.isPasswordInputType(view.getInputType()) && !TextUtils.isEmpty((CharSequence)view.getHint())) {
            view.setContentDescription(view.getHint());
        }
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    static String getProcessName() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ApisP.getProcessName();
        }
        try {
            Class<?> activityThreadClazz = Class.forName("android.app.ActivityThread");
            return (String)activityThreadClazz.getMethod("currentProcessName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isRunningInUserTestHarness() {
        if (Build.VERSION.SDK_INT >= 29) {
            return ApisQ.isRunningInUserTestHarness();
        }
        return false;
    }

    public static Bitmap getBitmapByUri(ContentResolver cr, Uri uri) throws IOException {
        if (Build.VERSION.SDK_INT >= 28) {
            return ApisP.getBitmapByUri(cr, uri);
        }
        return MediaStore.Images.Media.getBitmap((ContentResolver)cr, (Uri)uri);
    }

    private static class ApisLmr1 {
        private ApisLmr1() {
        }

        static void setAccessibilityTraversalBefore(View view, int viewFocusedAfter) {
            view.setAccessibilityTraversalBefore(viewFocusedAfter);
        }
    }

    @RequiresApi(value=23)
    private static class ApisM {
        private ApisM() {
        }

        public static void setStatusBarIconColor(View rootView, boolean useDarkIcons) {
            int systemUiVisibility = rootView.getSystemUiVisibility();
            systemUiVisibility = useDarkIcons ? (systemUiVisibility |= 0x2000) : (systemUiVisibility &= 0xFFFFDFFF);
            rootView.setSystemUiVisibility(systemUiVisibility);
        }
    }

    @RequiresApi(value=24)
    private static class ApisN {
        private ApisN() {
        }

        static String toHtml(Spanned spanned, int option) {
            return Html.toHtml((Spanned)spanned, (int)option);
        }

        @RequiresApi(value=25)
        static boolean isDemoUser() {
            UserManager userManager = (UserManager)ContextUtils.getApplicationContext().getSystemService("user");
            return userManager.isDemoUser();
        }

        static String getLocale(InputMethodSubtype inputMethodSubType) {
            return inputMethodSubType.getLanguageTag();
        }

        static boolean isInMultiWindowMode(Activity activity) {
            return activity.isInMultiWindowMode();
        }
    }

    @RequiresApi(value=26)
    private static class ApisO {
        private ApisO() {
        }

        static void initNotificationSettingsIntent(Intent intent, String packageName) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", packageName);
        }

        static void disableSmartSelectionTextClassifier(TextView textView) {
            textView.setTextClassifier(TextClassifier.NO_OP);
        }

        static Bundle createLaunchDisplayIdActivityOptions(int displayId) {
            ActivityOptions options = ActivityOptions.makeBasic();
            options.setLaunchDisplayId(displayId);
            return options.toBundle();
        }
    }

    @RequiresApi(value=28)
    private static class ApisP {
        private ApisP() {
        }

        static String getProcessName() {
            return Application.getProcessName();
        }

        static Bitmap getBitmapByUri(ContentResolver cr, Uri uri) throws IOException {
            return ImageDecoder.decodeBitmap((ImageDecoder.Source)ImageDecoder.createSource((ContentResolver)cr, (Uri)uri));
        }
    }

    @RequiresApi(value=29)
    private static class ApisQ {
        private ApisQ() {
        }

        static boolean isRunningInUserTestHarness() {
            return ActivityManager.isRunningInUserTestHarness();
        }

        static List<Integer> getTargetableDisplayIds(@Nullable Activity activity) {
            ArrayList<Integer> displayList = new ArrayList<Integer>();
            if (activity == null) {
                return displayList;
            }
            DisplayManager displayManager = (DisplayManager)activity.getSystemService("display");
            if (displayManager == null) {
                return displayList;
            }
            Display[] displays = displayManager.getDisplays();
            ActivityManager am = (ActivityManager)activity.getSystemService("activity");
            for (Display display : displays) {
                if (display.getState() != 2 || !am.isActivityStartAllowedOnDisplay((Context)activity, display.getDisplayId(), new Intent((Context)activity, activity.getClass()))) continue;
                displayList.add(display.getDisplayId());
            }
            return displayList;
        }
    }
}

