/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * !!!!! DO NOT CHANGE THE LOGIC IN THIS FILE !!!!!
 * Do not edit this file other than updating policy's interface.
 *
 * This file was generated from
 *   suggest/policyimpl/dictionary/structure/v4/bigram/ver4_bigram_list_policy.h
 */

#ifndef LATINIME_BACKWARD_V402_VER4_BIGRAM_LIST_POLICY_H
#define LATINIME_BACKWARD_V402_VER4_BIGRAM_LIST_POLICY_H

#include "defines.h"
#include "suggest/core/policy/dictionary_bigrams_structure_policy.h"
#include "suggest/policyimpl/dictionary/structure/backward/v402/content/bigram_entry.h"

namespace latinime {
namespace backward {
namespace v402 {

class BigramDictContent;
} // namespace v402
} // namespace backward
class NgramProperty;
namespace backward {
namespace v402 {
} // namespace v402
} // namespace backward
class HeaderPolicy;
namespace backward {
namespace v402 {
class TerminalPositionLookupTable;

class Ver4BigramListPolicy : public DictionaryBigramsStructurePolicy {
 public:
    Ver4BigramListPolicy(BigramDictContent *const bigramDictContent,
            const TerminalPositionLookupTable *const terminalPositionLookupTable,
            const HeaderPolicy *const headerPolicy)
            : mBigramDictContent(bigramDictContent),
              mTerminalPositionLookupTable(terminalPositionLookupTable),
              mHeaderPolicy(headerPolicy) {}

    void getNextBigram(int *const outBigramPos, int *const outProbability,
            bool *const outHasNext, int *const bigramEntryPos) const;

    bool skipAllBigrams(int *const pos) const {
        // Do nothing because we don't need to skip bigram lists in ver4 dictionaries.
        return true;
    }

    bool addNewEntry(const int terminalId, const int newTargetTerminalId,
            const NgramProperty *const ngramProperty, bool *const outAddedNewEntry);

    bool removeEntry(const int terminalId, const int targetTerminalId);

    bool updateAllBigramEntriesAndDeleteUselessEntries(const int terminalId,
            int *const outBigramCount);

    int getBigramEntryConut(const int terminalId);

 private:
    DISALLOW_IMPLICIT_CONSTRUCTORS(Ver4BigramListPolicy);

    int getEntryPosToUpdate(const int targetTerminalIdToFind, const int bigramListPos,
            int *const outTailEntryPos) const;

    const BigramEntry createUpdatedBigramEntryFrom(const BigramEntry *const originalBigramEntry,
            const NgramProperty *const ngramProperty) const;

    bool updateHasNextFlag(const bool hasNext, const int bigramEntryPos);

    BigramDictContent *const mBigramDictContent;
    const TerminalPositionLookupTable *const mTerminalPositionLookupTable;
    const HeaderPolicy *const mHeaderPolicy;
};
} // namespace v402
} // namespace backward
} // namespace latinime
#endif /* LATINIME_BACKWARD_V402_VER4_BIGRAM_LIST_POLICY_H */
