/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.inputmethod.compat;

import android.view.accessibility.AccessibilityEvent;

import java.lang.reflect.Field;

public class AccessibilityEventCompatUtils {
    public static final int TYPE_VIEW_HOVER_ENTER = 0x80;
    public static final int TYPE_VIEW_HOVER_EXIT = 0x100;

    private static final Field FIELD_TYPE_VIEW_HOVER_ENTER = CompatUtils.getField(
            AccessibilityEvent.class, "TYPE_VIEW_HOVER_ENTER");
    private static final Field FIELD_TYPE_VIEW_HOVER_EXIT = CompatUtils.getField(
            AccessibilityEvent.class, "TYPE_VIEW_HOVER_EXIT");
    private static final Integer OBJ_TYPE_VIEW_HOVER_ENTER = (Integer) CompatUtils
            .getFieldValue(null, null, FIELD_TYPE_VIEW_HOVER_ENTER);
    private static final Integer OBJ_TYPE_VIEW_HOVER_EXIT = (Integer) CompatUtils
            .getFieldValue(null, null, FIELD_TYPE_VIEW_HOVER_EXIT);

    public static boolean supportsTouchExploration() {
        return OBJ_TYPE_VIEW_HOVER_ENTER != null && OBJ_TYPE_VIEW_HOVER_EXIT != null;
    }
}
