/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.inputmethod.compat;

import android.inputmethodservice.InputMethodService;
import android.view.View;

public class ViewOutlineProviderCompatUtils {
    private ViewOutlineProviderCompatUtils() {
        // This utility class is not publicly instantiable.
    }

    public interface InsetsUpdater {
        public void setInsets(final InputMethodService.Insets insets);
    }

    private static final InsetsUpdater EMPTY_INSETS_UPDATER = new InsetsUpdater() {
        @Override
        public void setInsets(final InputMethodService.Insets insets) {}
    };

    public static InsetsUpdater setInsetsOutlineProvider(final View view) {
        if (BuildCompatUtils.EFFECTIVE_SDK_INT < BuildCompatUtils.VERSION_CODES_LXX) {
            return EMPTY_INSETS_UPDATER;
        }
        return ViewOutlineProviderCompatUtilsLXX.setInsetsOutlineProvider(view);
    }
}
